<?php
/*
   Plugin name: Behpardakht mellat gateway for Woocommerce
   Plugin URI: https://www.zhaket.com/web/mellat-woocommerce-gateway
   Description: Behpardakht Bank mellat gateway for Woocommerce
   Version: 1.6.0
   Author: Mojtaba Darvishi
   Author URI: https://mojtaba.dev
   Text Domain: behpardakht
   Domain Path: /languages
*/
namespace Behpardakht_WC_Gateway;

/**
 * Main Behpardakht Gateway Class.
 *
 * @class Behpardakht_WC_Main
 * @version    1.2.1
 */
class Main {

	/**
	 * The single instance of the class.
	 *
	 * @var Main
	 */
	protected static $_instance = null;

	/**
	 * Name of plugin in wordpress admin area
	 * @var
	 */
	private $name;


	/**
	 * Description of plugin in wordpress admin area
	 * @var
	 */
	private $description;

	/**
	 * Author of the plugin
	 * @var
	 */
	private $author;

	public static $version = '1.6.0';

	/**
	 * Behpardakht_WC_Main constructor.
	 */
	public function __construct() {
		$this->define_constants();
		$this->init_hooks();

        add_action('init', function () {
            $this->name   = __( 'Behpardakht mellat gateway for Woocommerce', 'behpardakht' );
            $this->author = __( 'Mojtaba Darvishi', 'behpardakht' );
        });

		include_once( BEHPARDAKHT_PATH . 'includes/Activator/Activator.php' );
		Activator::instance(
			'68bdc3e9-a602-4b42-bfc3-0853c4e5e7cb',
			$this->name,
			'1.3.0',
			'woocommerce',
			true
		);
	}

	/**
	 * Hook into actions and filters.
	 */
	private function init_hooks() {
		add_action( 'plugins_loaded', array( $this, 'localization' ) );
		add_action( 'plugins_loaded', array( $this, 'includes' ) );
		add_filter( 'woocommerce_payment_gateways', array( $this, 'add_gateway' ) );
	}

	/**
	 * Make plugin translatable
	 */
	public function localization() {
		$plugin_rel_path = plugin_basename( BEHPARDAKHT_PATH ) . '/languages';
        if ( version_compare( $GLOBALS['wp_version'], '6.7', '<' ) ) {
            load_plugin_textdomain( 'behpardakht', false, $plugin_rel_path );
        } else {
            load_textdomain( 'behpardakht', $plugin_rel_path . '/behpardakht-' . determine_locale() . '.mo' );
        }
	}

	/**
	 *
	 * Add plugin gateway class to woocommerce gateways
	 *
	 * @param $gateways
	 *
	 * @return array
	 */
	public function add_gateway( $gateways ) {
		$gateways[] = 'WC_Behpardakht_Gateway';

		return $gateways;
	}

	/**
	 * Main Gateway Instance.
	 *
	 * Ensures only one instance of Behpardakht Gateway is loaded or can be loaded.
	 *
	 * @static
	 * @return Main Gateway - Main instance.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}


	/**
	 * Define Behpardakht Constants.
	 */
	private function define_constants() {
		$this->define( 'BEHPARDAKHT_URL', plugin_dir_url( __FILE__ ) );
		$this->define( 'BEHPARDAKHT_PATH', plugin_dir_path( __FILE__ ) );
	}

	/**
	 * Define constant if not already set.
	 *
	 * @param  string $name
	 * @param  string|bool $value
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	/**
	 * Include required core files used in admin and on the frontend.
	 */
	public function includes() {
		/**
		 * Gateway Class.
		 */
		include_once( BEHPARDAKHT_PATH . 'includes/class-gateway.php' );
	}

}

function get_instance_behpardakht_gateway() {
	return Main::instance();
}
get_instance_behpardakht_gateway();
