<?php namespace Behpardakht_WC_Gateway; ?>
<p>
    <?php
    // TODO: Add terms and conditions link
    printf(
	    __('Before using product need to activate it. Activating this products means you accept %s our terms and conditions %s', $this->text_domain ),
        sprintf('<a href="%s" target="_blank">', Activator::$terms_url),
        '</a>'
    )
    ?>
</p>
<form class="activation">
	<?php if( $this->is_licensed ): ?>
		<p class="license_field">
			<label for="license"><?php _e('License code', $this->text_domain); ?></label>
			<input type="text" id="license">
		</p>
	<?php endif; ?>

	<p class="accept_terms_field">
		<input type="checkbox" id="accept_terms">
		<label for="accept_terms">
			<?php printf(
				__('I accept all %sTerms%s', $this->text_domain),
				sprintf('<a href="%s" target="_blank">', Activator::$terms_url),
				'</a>'
			); ?>
		</label>
	</p>
	<button><?php _e( 'Activate', $this->text_domain ); ?></button>
	<div class="spinner"><?php _e( 'Activating...', $this->text_domain ); ?></div>
	<div class="result"></div>
</form>
<script>
  jQuery(document).ready(function ($) {
    var ajax_url = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
    var is_licensed = <?php echo $this->is_licensed ? 'true' : 'false' ; ?>;
    jQuery(document).on('submit', '.wrap.<?php echo $this->product_slug ?> .activation', function (event) {
      event.preventDefault();
      var license = jQuery(this).find('#license').val();
      var activatorForm = jQuery(this);
      if( activatorForm.hasClass('waiting') ) {
        return;
      }
      activatorForm.addClass('waiting');
      activatorForm.find('.button').addClass('disabled');

      $('.result').html('');


      if( is_licensed && !license ) {
        $('.result').html('<span class="message danger"><?php _e('Please enter license code', $this->text_domain );?></span>');
        activatorForm.removeClass('waiting');
        return;
      }
      if( !activatorForm.find('#accept_terms').prop('checked') === true ) {
        $('.result').html('<span class="message danger"><?php _e('Please accept terms', $this->text_domain );?></span>');
        activatorForm.removeClass('waiting');
        return;
      }

      jQuery.ajax({
        url: ajax_url,
        type: 'POST',
        dataType: 'json',
        data: {
          action: 'guard_<?php echo $this->product_slug ?>_activator',
          license: license,
        },
      })
        .done(function (result) {
          if( result.success ) {
            $('.result').html('<span class="message success">'+result.data+'</span>');
            location.reload();
          } else {
            $('.result').html('<span class="message danger">'+result.data+'</span>');
          }
        })
        .fail(function (result) {
          $('.result').html('<span class="message danger">'+result.data+'</span>');
        })
        .always(function (result) {
          console.log(result);
          activatorForm.removeClass('waiting');
          activatorForm.find('.button').removeClass('disabled');
        });
    });

  });
</script>
