<?php namespace Behpardakht_WC_Gateway; ?>
<div class="status">
    <div class=" <?php echo $status; ?>">
        <img src="<?php echo  $this->url ?>assets/images/status-<?php echo $status; ?>.png" alt="" class="img-active">
        <h3><?php echo $message; ?></h3>
        <ul class="active_data">
			<?php if( $this->is_licensed ): ?>
                <li>
                    <strong><?php _e('License', $this->text_domain); ?></strong>
                    <code><?php echo $license ?></code>
                </li>
			<?php endif; ?>
        </ul>
    </div>
    <div class="action_buttons">
        <div class="buttons">
            <a href="#" class="deactivate">
                <?php
                echo $status == 'active' ? __('Deactivate', $this->text_domain) : __('Remove data and submit new data', $this->text_domain);
                ?>
            </a>
        </div>
        <div class="spinner"><?php _e( 'Checking...', $this->text_domain ); ?></div>
        <div class="result"></div>
    </div>
</div>
<script>
  jQuery(document).ready(function ($) {
    var ajax_url = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
    var is_licensed = <?php echo $this->is_licensed ? 'true' : 'false' ; ?>;

    jQuery(document).on('click', '.wrap.<?php echo $this->product_slug ?> .deactivate', function (event) {
      event.preventDefault();
      var license = jQuery(this).find('#license').val();
      var checkButton = jQuery(this);
      if( checkButton.hasClass('disabled') ) {
        return;
      }
      checkButton.parents('.action_buttons').addClass('waiting');
      checkButton.addClass('disabled');

      $('.result').html('');

      jQuery.ajax({
        url: ajax_url,
        type: 'POST',
        dataType: 'json',
        data: {
          action: 'guard_<?php echo $this->product_slug; ?>_deactivator',
          license: license,
        },
      })
        .done(function (result) {
          if( result.success ) {
            $('.result').html('<span class="message success">'+result.data+'</span>');
            location.reload();
          } else {
            $('.result').html('<span class="message danger">'+result.data+'</span>');
          }
        })
        .fail(function (result) {
          $('.result').html('<span class="message danger">'+result.data+'</span>');
        })
        .always(function (result) {
          console.log(result);
          checkButton.removeClass('disabled');
          checkButton.parents('.action_buttons').removeClass('waiting');
          checkButton.find('.button').removeClass('disabled');
        });
    });

  });
</script>
