<?php

/**
 * Created by PhpStorm.
 * User: mojtaba
 * Date: 6/18/17
 * Time: 7:02 PM
 */
if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
	return;
}

class WC_Behpardakht_Gateway extends WC_Payment_Gateway {

	private $terminal_id;

	private $username;

	private $password;

	private $logo;

	private $debug_mode;

	private $error_callback;

	private $process_method;

	public function __construct() {
		$this->id                 = 'behpardakht_gateway';
		$this->has_fields         = true;
		$this->method_title       = __( 'Behpardakht mellat', 'behpardakht' );
		$this->method_description = __( 'Behpardakht Bank mellat gateway for Woocommerce', 'behpardakht' );

		// Load the settings.
		$this->init_form_fields();
		$this->init_settings();

		// Define user set variables
		$this->title          = $this->get_option( 'title' );
		$this->description    = $this->get_option( 'description' );
		$this->terminal_id    = $this->get_option( 'terminal_id' );
		$this->username       = $this->get_option( 'username' );
		$this->password       = $this->get_option( 'password' );
		$this->logo           = $this->get_option( 'logo' );
		$this->debug_mode     = $this->get_option( 'debug_mode' );
		$this->error_callback = $this->get_option( 'error_callback' );
		$this->process_method = $this->get_option( 'process_method' );
		$this->icon           = sprintf( '%sassets/images/%s.png ', BEHPARDAKHT_URL, $this->logo );

		// Actions
		add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array(
			$this,
			'process_admin_options'
		) );
		add_action( 'woocommerce_receipt_' . $this->id, array( $this, 'send_to_bank' ) );
		add_action( 'woocommerce_api_' . strtolower( get_class( $this ) ), array( $this, 'return_from_bank' ) );
		add_filter( 'woocommerce_get_order_item_totals', array( $this, 'show_transaction_in_order' ), 10, 2 );
	}

	/**
	 * Initialise Gateway Settings Form Fields.
	 */
	public function init_form_fields() {
		$this->form_fields = array(
			'enabled'        => array(
				'title'   => __( 'Enable/Disable', 'behpardakht' ),
				'type'    => 'checkbox',
				'label'   => __( 'Enable behpardakht Payments', 'behpardakht' ),
				'default' => 'yes',
			),
			'logo'           => array(
				'title'       => __( 'Logo', 'behpardakht' ),
				'type'        => 'select',
				'description' => __( 'This controls the title which the user sees during checkout.', 'behpardakht' ),
				'default'     => 'behpardakht',
				'desc_tip'    => true,
				'options'     => array(
					'behpardakht-small' => __( 'Behpardakht', 'behpardakht' ),
					'mellat'            => __( 'Bank mellat', 'behpardakht' ),
				),
			),
			'error_callback' => array(
				'title'       => __( 'Error callback page', 'behpardakht' ),
				'type'        => 'select',
				'description' => __( 'If there was an error in payment, return to which page?', 'behpardakht' ),
				'default'     => 'cart',
				'desc_tip'    => true,
				'options'     => array(
					'checkout' => __( 'Checkout', 'behpardakht' ),
					'cart'     => __( 'Cart', 'behpardakht' ),
				),
			),
			'process_method' => array(
				'title'       => __( 'Payment process method', 'behpardakht' ),
				'type'        => 'select',
				'description' => __( 'How to redirect to bank?', 'behpardakht' ),
				'default'     => 'direct',
				'desc_tip'    => true,
				'options'     => array(
					'direct'      => __( 'Direct', 'behpardakht' ),
					'user_action' => __( 'User submit form', 'behpardakht' ),
				),
			),
			'title'          => array(
				'title'       => __( 'Title', 'behpardakht' ),
				'type'        => 'text',
				'description' => __( 'This controls the title which the user sees during checkout.', 'behpardakht' ),
				'default'     => __( 'Behpardakht mellat', 'behpardakht' ),
				'desc_tip'    => true,
			),
			'description'    => array(
				'title'       => __( 'Description', 'behpardakht' ),
				'type'        => 'textarea',
				'description' => __( 'Payment method description that the customer will see on your checkout.',
					'behpardakht' ),
				'default'     => __( 'Pay your order with shetab cart through Behpardakht Bank mellat gateway',
					'behpardakht' ),
				'desc_tip'    => true,
			),
			'terminal_id'    => array(
				'title'       => __( 'Terminal ID', 'behpardakht' ),
				'type'        => 'text',
				'description' => __( 'Insert merchant id that received from behpardakht', 'behpardakht' ),
			),
			'username'       => array(
				'title'       => __( 'Username', 'behpardakht' ),
				'type'        => 'text',
				'description' => __( 'Enter gateway username', 'behpardakht' ),
			),
			'password'       => array(
				'title'       => __( 'Password', 'behpardakht' ),
				'type'        => 'text',
				'description' => __( 'Enter gateway password', 'behpardakht' ),
			),
			'debug_mode'     => array(
				'title'   => __( 'Debug mode', 'behpardakht' ),
				'type'    => 'checkbox',
				'label'   => __( 'If active this option, gateway will only available for admins', 'behpardakht' ),
				'default' => 'no',
			),
		);
	}

	/**
	 * Process the payment and return the result.
	 *
	 * @param int $order_id
	 *
	 * @return array
	 */
	public function process_payment( $order_id ) {
		$order = wc_get_order( $order_id );

		return array(
			'result'   => 'success',
			'redirect' => $order->get_checkout_payment_url( $order ),
		);
	}

	/**
	 * Make ready for send to bank.
	 */
	public function send_to_bank( $order_id ) {

		if ( $this->debug_mode === 'yes' && ! current_user_can( 'administrator' ) ) {
			$error_message = $this->get_error_message( 'debug_mode' );
			wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
			wp_safe_redirect( $this->get_error_return_url() );
			exit();
		}

		if ( ! extension_loaded( 'soap' ) ) {
			$error_message = $this->get_error_message( 'soap' );
			wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
			wp_safe_redirect( $this->get_error_return_url() );
			exit();
		}
		$this->post_form( $order_id );
	}

	public function post_form( $order_id ) {
		$order    = wc_get_order( $order_id );
		$currency = $order->get_currency();
		$amount   = intval( $order->get_total() );
		if ( strtolower( $currency ) == strtolower( 'IRT' ) || strtolower( $currency ) == strtolower( 'TOMAN' ) || strtolower( $currency ) == strtolower( 'Iran TOMAN' ) || strtolower( $currency ) == strtolower( 'Iranian TOMAN' ) || strtolower( $currency ) == strtolower( 'Iran-TOMAN' ) || strtolower( $currency ) == strtolower( 'Iranian-TOMAN' ) || strtolower( $currency ) == strtolower( 'Iran_TOMAN' ) || strtolower( $currency ) == strtolower( 'Iranian_TOMAN' ) || strtolower( $currency ) == strtolower( 'تومان' ) || strtolower( $currency ) == strtolower( 'تومان ایران' ) ) {
			$amount = $amount * 10;
		} elseif ( strtolower( $currency ) == strtolower( 'IRHT' ) ) {
			$amount = $amount * 1000 * 10;
		} elseif ( strtolower( $currency ) == strtolower( 'IRHR' ) ) {
			$amount = $amount * 1000;
		}
		$terminal_id     = $this->terminal_id;
		$username        = $this->username;
		$password        = $this->password;
		$additional_data = sprintf( __( 'Order ID: %d - Customer Email: %d', '' ), $order_id,
			$order->get_billing_email() );
		$callback_url    = add_query_arg( 'wc_order', $order_id, WC()->api_request_url( 'WC_Behpardakht_Gateway' ) );

		WC()->session->set( 'behpardakht_order_id', $order_id );

		try {
			$soap_client   = new soapclient( 'https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl' );
			$sale_order_id = time();
			$parameters    = array(
				'terminalId'     => $terminal_id,
				'userName'       => $username,
				'userPassword'   => $password,
				'orderId'        => $sale_order_id,
				'amount'         => $amount,
				'mobileNo'       => $order->get_billing_phone(),
				'localDate'      => date( "Ymd" ),
				'localTime'      => date( "His" ),
				'additionalData' => $additional_data,
				'callBackUrl'    => $callback_url,
				'payerId'        => $order->get_customer_id()
			);
			$response      = $soap_client->bpPayRequest( $parameters );
			// Send post method
			$result        = explode( ',', $response->return );
			$response_code = $result['0'];
			$RefId         = $result['1'];
			if ( $response_code == 0 ) {
				// Store it to check for settle
				update_post_meta( $order_id, 'behpardakht_SaleOrderId', $sale_order_id );
				update_post_meta( $order_id, 'behpardakht_RefId', $RefId );

				$post_url = 'https://bpm.shaparak.ir/pgwchannel/startpay.mellat';
				$form     = $this->render_form($post_url, $RefId, $order);
				echo _e( 'Thank you for your payment. redirecting to bank...', 'behpardakht' ) . '<br>' . $form;
			} else {
				$error_message = $this->get_error_message( $response->return );
				wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
				wp_safe_redirect( $this->get_error_return_url() );
				exit();
			}
		} catch ( Exception $e ) {
			$error_message = $this->get_error_message( 'bank_connection_bpPayRequest' );
			$order->add_order_note( __( 'Payment error: ', 'behpardakht' ) . $error_message );
			wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
			wp_safe_redirect( $this->get_error_return_url() );
			exit();
		}

	}

	public function return_from_bank() {
		if ( isset( $_GET['wc_order'] ) ) {
			$order_id = absint( $_GET['wc_order'] );
		} else {
			$order_id = absint( WC()->session->get( 'behpardakht_order_id' ) );
		}
		if ( isset( $order_id ) && ! empty( $order_id ) ) {
			$order = wc_get_order( $order_id );
			if ( $order->get_status() !== 'completed' ) {
				// Get data from bank
				$terminal_id       = $this->terminal_id;
				$username          = $this->username;
				$password          = $this->password;
				$sale_order_id     = $_POST['SaleOrderId'];
				$sale_reference_id = $_POST['SaleReferenceId'];
				$RefId             = $_POST['RefId'];
				$response_code     = $_POST['ResCode'];

				if ( $response_code == 0 ) {
					// Verifying transaction
					$send_sale_order_id = get_post_meta( $order_id, 'behpardakht_SaleOrderId', true );
					$send_reference_id  = get_post_meta( $order_id, 'behpardakht_RefId', true );

					if ( $send_sale_order_id == $sale_order_id && $send_reference_id == $RefId ) {
						try {
							$parameters  = array(
								'terminalId'      => $terminal_id,
								'userName'        => $username,
								'userPassword'    => $password,
								'orderId'         => $sale_order_id,
								'saleOrderId'     => $sale_order_id,
								'saleReferenceId' => $sale_reference_id
							);
							$soap_client = new soapclient( 'https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl' );
							$verify      = $soap_client->bpVerifyRequest( $parameters );

							// Transaction verified
							if ( $verify->return == 0 ) {
								// Settle transaction
								try {
									$parameters = array(
										'terminalId'      => $terminal_id,
										'userName'        => $username,
										'userPassword'    => $password,
										'orderId'         => $sale_order_id,
										'saleOrderId'     => $sale_order_id,
										'saleReferenceId' => $sale_reference_id
									);
									$settle     = $soap_client->bpSettleRequest( $parameters );
									if ( $settle->return == 0 ) {
										// Everything is OK!
										wc_reduce_stock_levels( $order_id );
										WC()->cart->empty_cart();
										WC()->session->delete_session( 'behpardakht_order_id' );
										update_post_meta( $order_id, 'behpardakht_reference_id', $sale_reference_id );
										update_post_meta( $order_id, '_transaction_id', $sale_reference_id );
										$order->set_transaction_id($sale_reference_id);
										$message = sprintf( __( 'Payment was successful %s Tracking Code: %s',
											'behpardakht' ), '<br />', $sale_reference_id );
										$order->add_order_note( $message );
										$order->payment_complete();
										$successful_page = add_query_arg( 'wc_status', 'success',$this->get_return_url( $order ) );
										wp_redirect( $successful_page );
										exit();
									} else {
										// Settle failed. lets reverse
										try {
											$parameters = array(
												'terminalId'      => $terminal_id,
												'userName'        => $username,
												'userPassword'    => $password,
												'orderId'         => $sale_order_id,
												'saleOrderId'     => $sale_order_id,
												'saleReferenceId' => $sale_reference_id
											);
											$reversal   = $soap_client->bpReversalRequest( $parameters );
											if ( $reversal->return == 0 ) {
												$error_message = $this->get_error_message( 'successful_reversal' );
												wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message,
													'error' );
												$order->add_order_note( $error_message );
												wp_safe_redirect( $this->get_error_return_url() );
												exit();
											} else {
												$error_message = $this->get_error_message( 'failed_reversal' );
												wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message,
													'error' );
												$order->add_order_note( $error_message );
												wp_safe_redirect( $this->get_error_return_url() );
												exit();
											}
										} catch ( Exception $e ) {
											//var_dump($e->getMessage());
											$error_message = $this->get_error_message( 'bank_connection_bpReversalRequest' );
											$order->add_order_note( __( 'Payment error: ',
													'behpardakht' ) . $error_message );
											wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message,
												'error' );
											wp_safe_redirect( $this->get_error_return_url() );
											exit();
										}
									}

								} catch ( Exception $e ) {
									//var_dump($e->getMessage());
									$error_message = $this->get_error_message( 'bank_connection_bpSettleRequest' );
									$order->add_order_note( __( 'Payment error: ', 'behpardakht' ) . $error_message );
									wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
									wp_safe_redirect( $this->get_error_return_url() );
									exit();
								}

							} else {
								$error_message = $this->get_error_message( $verify );
								wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
								$order->add_order_note( $error_message );
								wp_safe_redirect( $this->get_error_return_url() );
								exit();
							}

						} catch ( Exception $e ) {
							//var_dump($e->getMessage());
							$error_message = $this->get_error_message( 'bank_connection_bpVerifyRequest' );
							$order->add_order_note( __( 'Payment error: ', 'behpardakht' ) . $error_message );
							wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
							wp_safe_redirect( $this->get_error_return_url() );
							exit();
						}
					} else {
						$error_message = $this->get_error_message( 'cheating' );
						wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
						wp_safe_redirect( $this->get_error_return_url() );
						exit();
					}
				} else {
					$error_message = $this->get_error_message( $response_code );
					wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
					wp_safe_redirect( $this->get_error_return_url() );
					exit();
				}
			} else {
				$error_message = $this->get_error_message( 'completed_order' );
				wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
				wp_safe_redirect( $this->get_error_return_url() );
				exit();
			}
		} else {
			$error_message = $this->get_error_message( 'order_id_existence' );
			wc_add_notice( __( 'Payment error: ', 'behpardakht' ) . $error_message, 'error' );
			wp_safe_redirect( $this->get_error_return_url() );
			exit();
		}
	}

	public function get_error_message( $token ) {
		switch ( $token ) {
			case '11':
				return __( 'Cart number is invalid', 'behpardakht' );
				break;
			case '12':
				return __( 'Inventory is not enough', 'behpardakht' );
				break;
			case '13':
				return __( 'Password is incorrect', 'behpardakht' );
				break;
			case '14':
				return __( 'Too many enter password attempt', 'behpardakht' );
				break;
			case '15':
				return __( 'Cart is invalid', 'behpardakht' );
				break;
			case '16':
				return __( 'Too many payment', 'behpardakht' );
				break;
			case '17':
				return __( 'User canceled payment', 'behpardakht' );
				break;
			case '18':
				return __( 'Cart is expired', 'behpardakht' );
				break;
			case '19':
				return __( 'Amount is more than valid', 'behpardakht' );
				break;
			case '21':
				return __( 'Receiver is invalid', 'behpardakht' );
				break;
			case '23':
				return __( 'Security error occurred', 'behpardakht' );
				break;
			case '24':
				return __( 'Receiver info is invalid', 'behpardakht' );
				break;
			case '25':
				return __( 'Amount is invalid', 'behpardakht' );
				break;
			case '31':
				return __( 'Answer is invalid', 'behpardakht' );
				break;
			case '32':
				return __( 'Info format is invalid', 'behpardakht' );
				break;
			case '33':
				return __( 'Account is invalid', 'behpardakht' );
				break;
			case '34':
				return __( 'Systematic error', 'behpardakht' );
				break;
			case '35':
				return __( 'Date is invalid', 'behpardakht' );
				break;
			case '41':
				return __( 'Res number is duplicated', 'behpardakht' );
				break;
			case '42':
				return __( 'Sale transaction not found', 'behpardakht' );
				break;
			case '43':
				return __( 'Verify request already sent', 'behpardakht' );
				break;
			case '44':
				return __( 'Verify request not found', 'behpardakht' );
				break;
			case '45':
				return __( 'Transaction is settled before', 'behpardakht' );
				break;
			case '46':
				return __( 'Transaction is not settled', 'behpardakht' );
				break;
			case '47':
				return __( 'Settled transaction not found', 'behpardakht' );
				break;
			case '48':
				return __( 'Transaction is Reversed', 'behpardakht' );
				break;
			case '49':
				return __( 'Transaction is Refunded', 'behpardakht' );
				break;
			case '51':
				return __( 'Transaction is duplicated', 'behpardakht' );
				break;
			case '54':
				return __( 'Transaction reference is not exist', 'behpardakht' );
				break;
			case '55':
				return __( 'Transaction is invalid', 'behpardakht' );
				break;
			case '61':
				return __( 'Error in withdraw', 'behpardakht' );
				break;
			case '111':
				return __( 'Cart creator is invalid', 'behpardakht' );
				break;
			case '112':
				return __( 'Cart creator switch error', 'behpardakht' );
				break;
			case '113':
				return __( 'Cart creator has no response', 'behpardakht' );
				break;
			case '114':
				return __( 'Cart owner not permitted to do this action', 'behpardakht' );
				break;
			case '415':
				return __( 'Session expired', 'behpardakht' );
				break;
			case '416':
				return __( 'Error in setting info', 'behpardakht' );
				break;
			case '417':
				return __( 'Payer id is no valid', 'behpardakht' );
				break;
			case '418':
				return __( 'Error in defining customer', 'behpardakht' );
				break;
			case '419':
				return __( 'Too many enter info attempt', 'behpardakht' );
				break;
			case '421':
				return __( 'IP is invalid', 'behpardakht' );
				break;
			case 'bank_connection_bpPayRequest':
				return __( 'Connection to bank failed in bpPayRequest method', 'behpardakht' );
				break;
			case 'bank_connection_bpReversalRequest':
				return __( 'Connection to bank failed in bpReversalRequest method', 'behpardakht' );
				break;
			case 'bank_connection_bpSettleRequest':
				return __( 'Connection to bank failed in bpSettleRequest method', 'behpardakht' );
				break;
			case 'bank_connection_bpVerifyRequest':
				return __( 'Connection to bank failed in bpVerifyRequest method', 'behpardakht' );
				break;
			case 'soap':
				return __( 'Soap module not found', 'behpardakht' );
				break;
			case 'settle':
				return __( 'Settle error', 'behpardakht' );
				break;
			case 'successful_reversal':
				return __( 'Payment was failed and amount successfully reversed to customer', 'behpardakht' );
				break;
			case 'failed_reversal':
				return __( 'Payment and reversal was failed', 'behpardakht' );
				break;
			case 'order_id_existence':
				return __( 'Order id does not exist', 'behpardakht' );
				break;
			case 'completed_order':
				return __( 'Order completed before', 'behpardakht' );
				break;
			case 'cheating':
				return __( 'Returned date from bank is not the same as sent data.', 'behpardakht' );
				break;
			case 'debug_mode':
				return __( 'Sorry! this payment method is no available now', 'behpardakht' );
				break;
			default:
				return __( 'Unknown error', 'behpardakht' );
		}
	}

	public function show_transaction_in_order( $total_rows, WC_Order $order ) {
		$gateway = $order->get_payment_method();
		if ( $gateway === $this->id ) {
			$trace_number               = get_post_meta( $order->get_id(), 'behpardakht_reference_id', true );
			$total_rows['trace_number'] = array(
				'label' => __( 'Tracking Code:', 'behpardakht' ),
				'value' => $trace_number
			);
		}

		return $total_rows;
	}

	public function get_error_return_url() {
		if ( $this->error_callback === 'checkout' ) {
			$url = wc_get_checkout_url();
		} else {
			$url = wc_get_cart_url();
		}

		return $url;
	}

	public function render_form($post_url, $RefId, WC_Order $order) {
		if( $this->process_method === 'direct' ) {
			$form = '<form id="behpardakht_hidden_form" method="post" action="' . $post_url . '" style="display: none !important">
                        <input type="hidden" name="RefId" value="' . $RefId . '">
                        <input type="hidden" name="mobileNo" value="' . $order->get_billing_phone() . '">
                        <script type="text/javascript">
                            document.getElementById("behpardakht_hidden_form").submit();
                        </script>
                    </form>';
		} else {
			$form = '<form id="behpardakht_hidden_form" method="post" action="' . $post_url . '" >
                        <input type="hidden" name="RefId" value="' . $RefId . '">
                        <input type="submit"  value="' . __('Pay', 'behpardakht') . '" style="display:inline-block; background: #2dbe60; color:#fff" >
                        <a href="'.wc_get_checkout_url().'" style="display:inline-block; background: #7b868a; color:#fff; padding: 5px 15px">'.__('Go back', 'behpardakht').'</a>
                    </form>';
		}

		return $form;
	}

}