<?php
function div($a, $b) {
    return (int) ($a / $b);
}

function gregorian_to_jalali ($gy, $gm, $gd) 
{ 
    $gdays_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31); 
    $j_days_in_month = array(31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29); 
 
  
   $gy = $gy-1600; 
   $gm = $gm-1; 
   $gd = $gd-1; 
 
   $gday_no = 365*$gy+div($gy+3,4)-div($gy+99,100)+div($gy+399,400); 
 
   for ($i=0; $i < $gm; ++$i) 
      $gday_no += $gdays_in_month[$i]; 
   if ($gm>1 && (($gy%4==0 && $gy%100!=0) || ($gy%400==0))) 
      /* leap and after Feb */ 
      $gday_no++; 
   $gday_no += $gd; 
 
   $j_day_no = $gday_no-79; 
 
   $j_np = div($j_day_no, 12053); /* 12053 = 365*33 + 32/4 */ 
   $j_day_no = $j_day_no % 12053; 
 
   $jy = 979+33*$j_np+4*div($j_day_no,1461); /* 1461 = 365*4 + 4/4 */ 
 
   $j_day_no %= 1461; 
 
   if ($j_day_no >= 366) { 
      $jy += div($j_day_no-1, 365); 
      $j_day_no = ($j_day_no-1)%365; 
   } 
 
   for ($i = 0; $i < 11 && $j_day_no >= $j_days_in_month[$i]; ++$i) 
      $j_day_no -= $j_days_in_month[$i]; 
   $jm = $i+1; 
   $jd = $j_day_no+1; 
 if($str) return $jy.'/'.$jm.'/'.$jd ;
   return array($jy, $jm, $jd); 
} 

function jalali_to_gregorian($jy, $jm, $jd) {
    $jy -= 979;
    $days = 365 * $jy + div($jy, 33) * 8 + div($jy % 33 + 3, 4) + $jd;
    if ($jm < 7) {
        $days += ($jm - 1) * 31;
    } else {
        $days += ($jm - 7) * 30 + 186;
    }
    $gy = 1600 + 400 * div($days, 146097);
    $days %= 146097;
    if ($days > 36524) {
        $gy += 100 * div(--$days, 36524);
        $days %= 36524;
        if ($days >= 365) $days++;
    }
    $gy += 4 * div($days, 1461);
    $days %= 1461;
    if ($days > 365) {
        $gy += div($days - 1, 365);
        $days = ($days - 1) % 365;
    }
    $gd = $days + 1;
    $sal_a = [0, 31, (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0)) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    for ($gm = 0; $gm < 13 && $gd > $sal_a[$gm]; $gm++) {
        $gd -= $sal_a[$gm];
    }
    return [$gy, $gm, $gd];
}









?>



