<?php


add_action('admin_enqueue_scripts', 'bpu_enqueue_admin_assets');
function bpu_enqueue_admin_assets() {

    // Select2 CDN
    wp_enqueue_style('select2-css', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');
    wp_enqueue_script('select2-js', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', ['jquery'], null, true);

    // فایل‌های پلاگین
    wp_enqueue_style('bpu-admin-css', JAHANBAZAR_PLUGIN_URL . 'assets/css/admin.css', [], '1.0.0');
    wp_enqueue_script('bpu-admin-js', JAHANBAZAR_PLUGIN_URL . 'assets/js/admin.js', ['jquery'], '1.0.0', true);
}



add_action('admin_menu', 'bpu_register_admin_menu');

function bpu_register_admin_menu() {
    add_menu_page(
        'بروزرسانی قیمت',
        'بروزرسانی قیمت',
        'manage_woocommerce',
        'bulk-price-updater',
        'bpu_render_admin_page',
        'dashicons-update',
        56
    );

    add_submenu_page(
        'bulk-price-updater',
        'ویرایش گروهی',
        'ویرایش گروهی',
        'manage_woocommerce',
        'bulk-edit-products',
        'bpu_render_bulk_edit_page'
    );


}

function bpu_render_admin_page() {
    ?>
    <div class="wrap">
        <h1>بروزرسانی گروهی قیمت‌ها</h1>
        <table class="form-table">
            <tr>
                <th scope="row"><label>دسته‌بندی محصول</label></th>
                <td>
                    <select id="bpu_category" name="category[]" multiple style="width: 300px; height: 150px;">
                        <?php
                        $terms = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
                        foreach ($terms as $term) {
                            echo "<option value='{$term->term_id}'>{$term->name}</option>";
                        }
                        ?>
                    </select>
                    <p class="description">برای انتخاب چند دسته، Ctrl (یا Cmd) را نگه دارید.</p>
                </td>
            </tr>
            <tr>
                <th><label>نوع تغییر</label></th>
                <td>
                    <select id="bpu_type">
                        <option value="increase">افزایشی</option>
                        <option value="decrease">کاهشی</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th><label>درصد تغییر (%)</label></th>
                <td><input type="number" id="bpu_percent" step="0.01" placeholder="مثال : 10"></td>
            </tr>
            <tr>
                <th><label>مقدار عددی (تومان)</label></th>
                <td>
                    <input type="text" id="bpu_amount" placeholder="مثلاً 20,000">
                </td>
            </tr>
            <tr>
                <th><label>اعمال فقط روی محصولات موجود</label></th>
                <td>
                    <label><input type="checkbox" id="bpu_only_instock" checked> فقط محصولات موجود (in stock)</label>
                </td>
            </tr>
        </table>
        <button class="button button-primary" id="bpu_submit">اعمال تغییرات</button>
        <div id="bpu_result" style="margin-top: 20px;"></div>
    </div>

    <script>
    jQuery(document).ready(function($){
        $('#bpu_amount').on('input', function() {
            let val = $(this).val().replace(/,/g, '');
            if (!isNaN(val)) {
                $(this).val(Number(val).toLocaleString('en-US'));
            }
        });

        $('#bpu_submit').on('click', function(){
            $('#bpu_result').html('در حال انجام عملیات...');

            let categories = $('#bpu_category').val();
            let type = $('#bpu_type').val();
            let percent = $('#bpu_percent').val();
            let amount = $('#bpu_amount').val().replace(/,/g, '');
            let only_instock = $('#bpu_only_instock').is(':checked') ? 1 : 0;

            $.post(ajaxurl, {
                action: 'bpu_update_prices',
                category: categories,
                type: type,
                percent: percent,
                amount: amount,
                only_instock: only_instock
            }, function(response){
                $('#bpu_result').html(response);
            });
        });
    });
    </script>
    <?php
}

add_action('wp_ajax_bpu_update_prices', function() {
    if ( ! current_user_can('manage_woocommerce') ) wp_die();

    $category_ids  = array_map('intval', (array) $_POST['category']);
    $type          = sanitize_text_field($_POST['type']);
    $percent       = floatval($_POST['percent']);
    $amount        = floatval(str_replace(',', '', $_POST['amount']));
    $only_instock  = intval($_POST['only_instock']);

    if (empty($category_ids)) {
        echo 'هیچ دسته‌ای انتخاب نشده است.';
        wp_die();
    }

    $args = [
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'tax_query'      => [[
            'taxonomy' => 'product_cat',
            'field'    => 'term_id',
            'terms'    => $category_ids,
            'operator' => 'IN',
        ]],
    ];

    $products = get_posts($args);
    $count = 0;

    foreach ($products as $product_post) {
        $product = wc_get_product($product_post->ID);

        if (!$product || ! $product->is_type('simple')) continue;

        if ($only_instock && $product->get_stock_status() !== 'instock') continue;

        $regular_price = floatval($product->get_regular_price());
        $sale_price    = floatval($product->get_sale_price());

        $change = 0;
        if ($percent != 0) {
            $change = $regular_price * ($percent / 100);
        } elseif ($amount != 0) {
            $change = $amount;
        } else {
            continue;
        }

        if ($type === 'decrease') $change *= -1;

        $new_regular = max(0, $regular_price + $change);
        $new_sale    = ($sale_price > 0) ? max(0, $sale_price + $change) : '';

        $product->set_regular_price($new_regular);
        if ($new_sale !== '') $product->set_sale_price($new_sale);

        $product->save();
        $count++;
    }

    echo "قیمت {$count} محصول با موفقیت بروزرسانی شد.";
    wp_die();
});





function bpu_render_bulk_edit_page() {
    ?>
    <div class="wrap">
        <h1 style="font-size: 26px; margin-bottom: 20px;">ویرایش گروهی محصولات</h1>

        <label for="bpu_edit_category" style="font-weight: bold; margin-bottom: 10px; display: inline-block;">انتخاب دسته‌بندی:</label>
        <select id="bpu_edit_category" style="min-width: 250px; padding: 5px; font-size: 15px;">
            <option value="">-- انتخاب کنید --</option>
            <?php
            $terms = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
            foreach ($terms as $term) {
                echo "<option value='{$term->term_id}'>{$term->name}</option>";
            }
            ?>
        </select>

        <input type="text" id="bpu_search_input" placeholder="جستجو در عنوان محصول..." style="margin-right: 15px; padding: 5px; font-size: 15px; width: 250px;" />
        <button id="bpu_search_btn" class="button" style="vertical-align: top;">جستجو</button>

        <div id="bpu_product_list" style="margin-top: 30px;"></div>
    </div>

    <style>
        .bpu-save-product {
            background-color: #2c7be5;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 5px;
            cursor: pointer;
        }
        .bpu-save-product:hover {
            background-color: #1a68d1;
        }
        .bpu-view-product {
            background-color: #28a745;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 5px;
            cursor: pointer;
        }
        .bpu-view-product:hover {
            background-color: #218838;
        }
        .bpu-pagination {
            margin-top: 20px;
            font-size: 15px;
        }
        .bpu-page-link {
            display: inline-block;
            margin: 0 5px;
            padding: 5px 10px;
            background-color: #f1f1f1;
            border-radius: 4px;
            color: #333;
            text-decoration: none;
        }
        .bpu-page-link.current {
            background-color: #0073aa;
            color: white;
        }
        #bpu_search_btn {
            background-color: #0073aa;
            color: #fff;
            border: none;
            padding: 7px 15px;
            font-size: 15px;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        #bpu_search_btn:hover {
            background-color: #005f8d;
        }
    </style>

    <script>
    jQuery(document).ready(function($){
        function loadPage(cat_id, page, keyword = '') {
            $('#bpu_product_list').html('در حال بارگذاری...');
            $.post(ajaxurl, {
                action: 'bpu_get_products_by_category',
                category_id: cat_id,
                page: page,
                keyword: keyword
            }, function(response){
                $('#bpu_product_list').html(response);
            });
        }

        function doSearch() {
            let cat_id = $('#bpu_edit_category').val();
            let keyword = $('#bpu_search_input').val();
            loadPage(cat_id, 1, keyword);
        }

        $('#bpu_search_btn').on('click', doSearch);

        $('#bpu_search_input').on('keypress', function(e){
            if (e.which === 13) {
                e.preventDefault();
                doSearch();
            }
        });

        $('#bpu_edit_category').on('change', doSearch);

        $(document).on('click', '.bpu-page-link', function(e){
            e.preventDefault();
            let cat_id = $('#bpu_edit_category').val();
            let page = $(this).data('page');
            let keyword = $('#bpu_search_input').val();
            loadPage(cat_id, page, keyword);
        });

        $(document).on('click', '.bpu-save-product', function(){
            const row = $(this).closest('tr');
            const data = {
                action: 'bpu_save_product_edit',
                product_id: row.data('id'),
                regular_price: row.find('.bpu_regular_price').val(),
                sale_price: row.find('.bpu_sale_price').val(),
                stock_qty: row.find('.bpu_stock').val(),
                warranty: row.find('.bpu_warranty').val(),
                sale_start: row.find('.bpu_sale_start').val(),
                sale_end: row.find('.bpu_sale_end').val(),
            };
            row.find('.bpu-status').html('در حال ذخیره...');
            $.post(ajaxurl, data, function(response){
                row.find('.bpu-status').html(response);
            });
        });
    });
    </script>
    <?php
}

add_action('wp_ajax_bpu_get_products_by_category', function() {
    $cat_id = intval($_POST['category_id']);
    $page = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $keyword = isset($_POST['keyword']) ? sanitize_text_field($_POST['keyword']) : '';
    $products_per_page = 20;

    $args = [
        'post_type' => 'product',
        'posts_per_page' => -1,
        's' => $keyword,
        'tax_query' => [[
            'taxonomy' => 'product_cat',
            'field'    => 'term_id',
            'terms'    => $cat_id,
        ]],
        'meta_query' => [[
            'key'     => '_stock_status',
            'compare' => 'EXISTS'
        ]]
    ];

    $query = new WP_Query($args);
    $all_products = $query->posts;

    usort($all_products, function($a, $b) {
        $a_stock = get_post_meta($a->ID, '_stock_status', true);
        $b_stock = get_post_meta($b->ID, '_stock_status', true);
        return ($a_stock == 'instock' ? -1 : 1) - ($b_stock == 'instock' ? -1 : 1);
    });

    $total_products = count($all_products);
    $total_pages = ceil($total_products / $products_per_page);
    $offset = ($page - 1) * $products_per_page;
    $paged_products = array_slice($all_products, $offset, $products_per_page);

    echo '<table class="wp-list-table widefat striped">';
    echo '<thead><tr>
            <th>عنوان</th>
            <th>قیمت عادی</th>
            <th>قیمت فروش ویژه</th>
            <th>موجودی</th>
            <th>گارانتی</th>
            <th>شروع فروش ویژه</th>
            <th>پایان فروش ویژه</th>
            <th>مشاهده</th>
            <th>عملیات</th>
        </tr></thead><tbody>';

    foreach ($paged_products as $product_post) {
        $product = wc_get_product($product_post->ID);
        if (!$product || !$product->is_type('simple')) continue;

        $reg_price = $product->get_regular_price();
        $sale_price = $product->get_sale_price();
        $stock = $product->get_stock_quantity();
        $warranty = get_post_meta($product->get_id(), 'dina_public_meta_value_one', true);
        $sale_start = $product->get_date_on_sale_from() ? $product->get_date_on_sale_from()->date('Y-m-d') : '';
        $sale_end = $product->get_date_on_sale_to() ? $product->get_date_on_sale_to()->date('Y-m-d') : '';
        $product_url = get_permalink($product->get_id());

        echo "<tr data-id='{$product->get_id()}'>
            <td>{$product->get_name()}</td>
            <td><input class='bpu_regular_price' type='number' step='0.01' value='{$reg_price}'></td>
            <td><input class='bpu_sale_price' type='number' step='0.01' value='{$sale_price}'></td>
            <td><input class='bpu_stock' type='number' value='{$stock}'></td>
            <td><input class='bpu_warranty' type='text' value='{$warranty}'></td>
            <td><input class='bpu_sale_start' type='date' value='{$sale_start}'></td>
            <td><input class='bpu_sale_end' type='date' value='{$sale_end}'></td>
            <td><a class='bpu-view-product' href='{$product_url}' target='_blank'> محصول</a></td>
            <td><button class='bpu-save-product'>ذخیره</button> <span class='bpu-status'></span></td>
        </tr>";
    }

    echo '</tbody></table>';

    if ($total_pages > 1) {
        echo '<div class="bpu-pagination">صفحات: ';
        for ($i = 1; $i <= $total_pages; $i++) {
            echo " <a href='#' class='bpu-page-link" . ($i == $page ? " current" : "") . "' data-page='{$i}'>{$i}</a> ";
        }
        echo '</div>';
    }

    wp_die();
});

add_action('wp_ajax_bpu_save_product_edit', function() {
    $id = intval($_POST['product_id']);
    $product = wc_get_product($id);
    if (!$product) {
        echo 'نامعتبر';
        wp_die();
    }

    $product->set_regular_price($_POST['regular_price']);
    $product->set_sale_price($_POST['sale_price']);
    $product->set_stock_quantity($_POST['stock_qty']);
    $product->set_date_on_sale_from($_POST['sale_start'] ? strtotime($_POST['sale_start']) : null);
    $product->set_date_on_sale_to($_POST['sale_end'] ? strtotime($_POST['sale_end']) : null);
    $product->save();

    if (isset($_POST['warranty'])) {
        update_post_meta($id, 'dina_public_meta_value_one', sanitize_text_field($_POST['warranty']));
    }

    echo 'ذخیره شد';
    wp_die();
});