<?php


// افزودن فیلدهای سفارشی به صفحه کوپن
add_action('woocommerce_coupon_options', 'woo_add_bulk_coupon_fields');
function woo_add_bulk_coupon_fields() {

    // محصولات عمده - با جستجو و انتخاب چندتایی
    ?>
    <p class="form-field">
        <label for="bulk_products">محصولات عمده</label>
        <select class="wc-product-search" multiple="multiple" style="width: 100%;" name="bulk_products[]" data-placeholder="جستجو و انتخاب محصولات" data-action="woocommerce_json_search_products_and_variations">
            <?php
            $product_ids = get_post_meta(get_the_ID(), 'bulk_products', true);
            if (!empty($product_ids) && is_array($product_ids)) {
                foreach ($product_ids as $product_id) {
                    $product = wc_get_product($product_id);
                    if ($product) {
                        echo '<option value="' . esc_attr($product_id) . '" selected>' . esc_html($product->get_name()) . '</option>';
                    }
                }
            }
            ?>
        </select>
        <span class="description">اگر یکی از این محصولات به تعداد کافی در سبد باشد، تخفیف اعمال می‌شود.</span>
    </p>
    <?php

    // دسته‌بندی عمده
    $terms = get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false));
    ?>
    <p class="form-field">
        <label for="bulk_categories">دسته‌بندی‌های عمده</label>
        <select name="bulk_categories[]" multiple style="width: 100%;">
            <?php foreach ($terms as $term): ?>
                <option value="<?= esc_attr($term->term_id); ?>" <?= selected(in_array($term->term_id, (array) get_post_meta(get_the_ID(), 'bulk_categories', true)), true, false); ?>>
                    <?= esc_html($term->name); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <span class="description">اگر محصولات این دسته‌ها به تعداد کافی در سبد باشند، تخفیف اعمال می‌شود.</span>
    </p>
    <?php

    // تعداد لازم
    woocommerce_wp_text_input(array(
        'id' => 'bulk_quantity',
        'label' => 'تعداد موردنیاز',
        'desc_tip' => true,
        'description' => 'حداقل تعداد موردنیاز از محصولات یا دسته‌های بالا برای فعال شدن کد تخفیف.',
        'type' => 'number',
        'custom_attributes' => array(
            'min' => 1,
            'step' => 1,
        ),
    ));
}

// ذخیره فیلدها
add_action('woocommerce_coupon_options_save', 'woo_save_bulk_coupon_fields');
function woo_save_bulk_coupon_fields($post_id) {
    update_post_meta($post_id, 'bulk_products', isset($_POST['bulk_products']) ? array_map('absint', $_POST['bulk_products']) : array());
    update_post_meta($post_id, 'bulk_categories', isset($_POST['bulk_categories']) ? array_map('absint', $_POST['bulk_categories']) : array());
    update_post_meta($post_id, 'bulk_quantity', isset($_POST['bulk_quantity']) ? absint($_POST['bulk_quantity']) : 0);
}

// بررسی شرط هنگام اعمال کدتخفیف
add_filter('woocommerce_coupon_is_valid', 'woo_check_bulk_coupon_condition', 10, 2);
function woo_check_bulk_coupon_condition($is_valid, $coupon) {
    $bulk_products = get_post_meta($coupon->get_id(), 'bulk_products', true);
    $bulk_categories = get_post_meta($coupon->get_id(), 'bulk_categories', true);
    $bulk_quantity = (int) get_post_meta($coupon->get_id(), 'bulk_quantity', true);

    if (empty($bulk_quantity)) {
        return $is_valid; // شرطی مشخص نشده
    }

    $matched_qty = 0;

    foreach (WC()->cart->get_cart() as $item) {
        $product_id = $item['product_id'];
        $qty = $item['quantity'];

        // بررسی محصولات خاص
        if (is_array($bulk_products) && in_array($product_id, $bulk_products)) {
            $matched_qty += $qty;
            continue;
        }

        // بررسی دسته‌بندی‌ها
        if (is_array($bulk_categories) && !empty($bulk_categories)) {
            $product_cats = wc_get_product_term_ids($product_id, 'product_cat');
            if (array_intersect($bulk_categories, $product_cats)) {
                $matched_qty += $qty;
            }
        }
    }

    if ($matched_qty < $bulk_quantity) {
        wc_add_notice('برای استفاده از این کدتخفیف، باید حداقل ' . $bulk_quantity . ' عدد از محصولات یا دسته‌بندی‌های مشخص‌شده در سبد شما باشد.', 'error');
        return false;
    }

    return true;
}
