<?php

// شورت‌کد برای نمایش کوپن‌های زمان‌دار در صفحات یا نوشته‌ها
add_shortcode('timed_coupons', function () {
    ob_start();

    $args = [
        'post_type'   => 'shop_coupon',
        'posts_per_page' => -1,
        'post_status' => 'publish',
    ];

    $coupons = get_posts($args);
    $timed_coupons = [];

    foreach ($coupons as $coupon) {
        $expiry_timestamp = get_post_meta($coupon->ID, 'date_expires', true);
        if (!empty($expiry_timestamp) && $expiry_timestamp > time()) {
            $timed_coupons[] = $coupon;
        }
    }

    if (empty($timed_coupons)) return '';

    ?>
    <div class="timed-coupons-box">
        <h3>کدهای تخفیف فعال</h3>
        <ul>
            <?php foreach ($timed_coupons as $coupon):
                $code = $coupon->post_title;
                $description = get_the_excerpt($coupon);
                $expiry = date_i18n('Y/m/d', get_post_meta($coupon->ID, 'date_expires', true));
            ?>
                <li>
                    <span class="coupon-bullet"></span>
                    <span class="coupon-code"><?php echo esc_html($code); ?></span>

                    <button class="copy-btn" data-code="<?php echo esc_attr($code); ?>">کپی</button>
                    <small class="expiry">تاریخ انقضا: <?php echo esc_html($expiry); ?></small>
                    <?php if ($description): ?>
                        <div class="description"><?php echo esc_html($description); ?></div>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php

    return ob_get_clean();
});

add_action('wp_footer', function () {
    echo '<script>
        document.addEventListener("DOMContentLoaded", function () {
            const buttons = document.querySelectorAll(".copy-btn");
            buttons.forEach(btn => {
                btn.addEventListener("click", function () {
                    const code = this.dataset.code;
                    navigator.clipboard.writeText(code).then(() => {
                        this.innerText = "کپی شد!";
                        setTimeout(() => {
                            this.innerText = "کپی";
                        }, 2000);
                    });
                });
            });
        });
    </script>';
});

