<?php

$link  = '';
$title = '';

add_filter('manage_edit-shop_order_columns', 'custom_add_order_columns');
function custom_add_order_columns($columns) {

    $new_columns = [];

    foreach ($columns as $key => $column) {

        $new_columns[$key] = $column;

        if ($key === 'order_total') {
            $new_columns['order_city']       = 'شهر';
            $new_columns['shipping_method']  = 'شیوه ارسال';
            $new_columns['discount_codes']   = 'کد تخفیف';
        }
    }

    return $new_columns;
}


add_action('manage_shop_order_posts_custom_column', 'custom_show_order_column_content');
function custom_show_order_column_content($column) {

    global $post;
    $order = wc_get_order($post->ID);

    switch ($column) {

        case 'order_city':
            echo esc_html($order->get_shipping_city());
            break;

        case 'shipping_method':
            $methods = [];

            foreach ($order->get_shipping_methods() as $method) {
                $methods[] = $method->get_name();
            }

            echo esc_html(implode(', ', $methods));
            break;

        case 'discount_codes':
            $coupons = $order->get_coupon_codes();

            if (!empty($coupons)) {
                echo esc_html(implode(', ', $coupons));
            } else {
                echo '-';
            }
            break;
    }
}
