<?php


// بارگذاری CSS و JS از CDN در صفحات محصول و سبد خرید
add_action('wp_enqueue_scripts', 'btslick_enqueue_assets_cdn');
function btslick_enqueue_assets_cdn() {
    if (is_product() || is_cart()) {
        // CSS های Slick از CDN
        wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css', [], '1.8.1');
        wp_enqueue_style('slick-theme', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css', ['slick-css'], '1.8.1');

        // CSS سفارشی برای استایل اسلایدر و دکمه‌ها
        wp_add_inline_style('slick-css', "
            .bt-slick-slider .product-card {
                background: #fff;
                border: 1px solid #ddd;
                border-radius: 8px;
                padding: 15px;
                margin: 0 10px;
                box-shadow: 0 2px 6px rgba(0,0,0,0.1);
                transition: box-shadow 0.3s ease;
                text-align: center;
                height: 320px;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
            }
            .bt-slick-slider .product-card:hover {
                box-shadow: 0 6px 15px rgba(0,0,0,0.2);
            }
            .bt-slick-slider .product-card img {
                max-width: 100%;
                height: 160px;
                object-fit: contain;
                margin-bottom: 12px;
            }
            .bt-slick-slider .product-card .product-title {
                font-size: 16px;
                font-weight: 600;
                color: #222;
                margin-bottom: 6px;
                flex-grow: 1;
                line-height: 1.2;
                overflow: hidden;
            }
            .bt-slick-slider .product-card .product-price {
                font-size: 15px;
                color: #e74c3c;
                font-weight: 700;
            }
            /* دکمه‌های ناوبری */
            .slick-prev:before, .slick-next:before {
                color: #555;
                font-size: 30px;
                opacity: 1 !important;
            }
            .bt-slick-container {
                max-width: 960px;
                margin: 40px auto 60px;
            }
            h3.bt-slick-title {
                text-align: center;
                font-size: 24px;
                margin-bottom: 20px;
                color: #444;
                font-weight: 700;
            }
        ");

        // JS Slick از CDN
wp_enqueue_script('slick-js',JAHANBAZAR_PLUGIN_URL . 'assets/js/slick.min.js',['jquery'],'1.8.1',true);


add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

        // اجرای اسلایدر پس از بارگذاری Slick
        wp_add_inline_script('slick-js', "
            jQuery(document).ready(function($) {
                $('.bt-slick-slider').slick({
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    arrows: true,
                    dots: true,
                    rtl: true,
                    responsive: [
                        { breakpoint: 992, settings: { slidesToShow: 2 } },
                        { breakpoint: 576, settings: { slidesToShow: 1 } }
                    ]
                });
            });
        ");
    }
}

// گرفتن محصولات مرتبط که همراه محصول خریداری شده‌اند
function btslick_get_related_products_ids($product_id) {
    $orders = wc_get_orders([
        'limit' => 100,
        'status' => 'completed',
        'return' => 'objects',
    ]);

    $related_ids = [];

    foreach ($orders as $order) {
        $item_ids = [];

        foreach ($order->get_items() as $item) {
            $item_ids[] = $item->get_product_id();
        }

        if (in_array($product_id, $item_ids)) {
            foreach ($item_ids as $id) {
                if ($id != $product_id) {
                    $related_ids[] = $id;
                }
            }
        }
    }

    if (empty($related_ids)) return [];

    $counts = array_count_values($related_ids);
    arsort($counts);
    return array_slice(array_keys($counts), 0, 10);
}

// نمایش اسلایدر فقط در صفحه محصول جاری (همین محصول) - اضافه کردن شرط دقیق
add_action('woocommerce_after_single_product_summary', 'btslick_render_slider_product_single_only', 25);
function btslick_render_slider_product_single_only() {
    if (!is_product()) return;

    global $product;
    $product_id = $product->get_id();

    // فقط اگر این صفحه محصول است، نمایش بده
    // یعنی مثلا اگر صفحه محصول دیگه هست نمایش نده (چون فقط همین صفحه فعلی را بررسی کردیم)

    $top_ids = btslick_get_related_products_ids($product_id);
    if (empty($top_ids)) return;

    btslick_render_slider_html($top_ids, 'محصولاتی که کاربران همراه این محصول خریده‌اند:');
}

// نمایش اسلایدر در صفحه سبد خرید
add_action('woocommerce_after_cart', 'btslick_render_slider_cart');
function btslick_render_slider_cart() {
    if (!is_cart()) return;

    $product_ids_in_cart = [];
    foreach (WC()->cart->get_cart() as $cart_item) {
        $product_ids_in_cart[] = $cart_item['product_id'];
    }

    if (empty($product_ids_in_cart)) return;

    // گرفتن محصولات مرتبط بر اساس همه محصولات در سبد
    $all_related = [];
    foreach ($product_ids_in_cart as $pid) {
        $related = btslick_get_related_products_ids($pid);
        $all_related = array_merge($all_related, $related);
    }

    if (empty($all_related)) return;

    // حذف محصولات تکراری و محصولات خود سبد خرید
    $all_related = array_diff(array_unique($all_related), $product_ids_in_cart);
    if (empty($all_related)) return;

    btslick_render_slider_html($all_related, 'محصولاتی که همراه محصولات سبد خرید شما خریداری شده‌اند:');
}

// رندر HTML اسلایدر
function btslick_render_slider_html($product_ids, $title = '') {
    echo '<div class="bt-slick-container">';
    if ($title) {
        echo '<h3 class="bt-slick-title">' . esc_html($title) . '</h3>';
    }
    echo '<div class="bt-slick-slider">';

    foreach ($product_ids as $id) {
        $p = wc_get_product($id);
        if (!$p) continue;

        echo '<div class="product-card">';
        echo '<a href="' . esc_url(get_permalink($id)) . '" style="text-decoration:none;">';
        echo $p->get_image('woocommerce_thumbnail');
        echo '<div class="product-title">' . esc_html($p->get_name()) . '</div>';
        echo '<div class="product-price">' . $p->get_price_html() . '</div>';
        echo '</a>';
        echo '</div>';
    }

    echo '</div></div>';
}
