<?php


add_filter('manage_edit-shop_order_columns', 'custom_add_payment_column');
function custom_add_payment_column($columns) {

    $new_columns = [];

    foreach ($columns as $key => $column) {

        $new_columns[$key] = $column;

        if ($key === 'order_total') {
            $new_columns['payment_info'] = 'شماره تراکنش';
        }
    }

    return $new_columns;
}


add_action('manage_shop_order_posts_custom_column', 'custom_show_payment_column');
function custom_show_payment_column($column) {

    if ($column !== 'payment_info') {
        return;
    }

    global $post;

    $order           = wc_get_order($post->ID);
    $payment_method  = $order->get_payment_method_title();
    $transaction_id  = $order->get_transaction_id();

    if ($payment_method) {

        $output  = '<strong>' . esc_html($payment_method) . '</strong>';

        if ($transaction_id) {
            $output .= '<br><small style="color:#555; font-size:13px; font-weight:400">'
                     . 'شماره تراکنش: ' . esc_html($transaction_id)
                     . '</small>';
        }

        echo $output;

    } else {
        echo '-';
    }
}
