<?php

add_filter('bulk_actions-edit-shop_order', 'add_custom_order_statuses_bulk_actions');

function add_custom_order_statuses_bulk_actions($bulk_actions) {
    $custom_statuses = array(
        'wc--1' => 'ارجاع به کارشناس 1',
        'wc--2' => 'ارجاع به کارشناس 2',
        'wc--3' => 'ارجاع به کارشناس 3',
        'wc-5'  => 'ارجاع به کارشناس 5',
        'wc--7' => 'انبار (در حال آماده سازی)',
        'wc-8'  => 'ارسال شده (کدرهگیری بزودی وارد میشود)',
        'wc-9-' => 'کدرهگیری در پنل کاربری وارد شد',
        'wc-10-'=> 'بصورت حضوری تحویل داده شد',
        'wc--11'=> 'ارسال شد توسط پیک',
        'wc-12-'=> 'عدم پاسخگویی تماس/سفارش معلق',
        'wc-13' => 'موجودی کامل نمی باشد',
        'wc-bzg'=> 'عدم موجودی کالا و بازگشت وجه',
        'wc--cashback'=> 'برگشت وجه با هماهنگی مشتری',
        'wc-cancelled'=> 'سفارش شما لغو شد',
        'wc-sm' => 'ثبت مجدد سفارش',
        'wc-k4' => 'ارجاع به کارشناس 4',
        'wc-verified'=> '✅ تایید سفارش و ارجاع به مالی',
        'wc-preparing' => 'در حال آماده‌سازی',
        'wc-reviewing' => 'در حال بررسی',
    );

    foreach($custom_statuses as $slug => $label){
        $bulk_actions['mark_'.$slug] = 'تغییر وضعیت به: '.$label;
    }

    return $bulk_actions;
}


add_filter('handle_bulk_actions-edit-shop_order', 'handle_custom_order_status_bulk_action', 10, 3);

function handle_custom_order_status_bulk_action($redirect_to, $doaction, $post_ids){
    if(strpos($doaction, 'mark_wc') === 0){ 
        $new_status = str_replace('mark_', '', $doaction);
        foreach($post_ids as $post_id){
            if(get_post_type($post_id) == 'shop_order'){
                $order = wc_get_order($post_id);
                if($order){
                    $order->update_status(str_replace('wc-', '', $new_status), 'تغییر وضعیت دسته جمعی'); 
                }
            }
        }
        $redirect_to = add_query_arg('bulk_custom_status_updated', count($post_ids), $redirect_to);
    }
    return $redirect_to;
}

add_action('admin_notices', 'custom_order_status_bulk_admin_notice');
function custom_order_status_bulk_admin_notice(){
    if(!empty($_REQUEST['bulk_custom_status_updated'])){
        $count = intval($_REQUEST['bulk_custom_status_updated']);
        echo '<div class="notice notice-success is-dismissible"><p>وضعیت '.$count.' سفارش با موفقیت تغییر یافت.</p></div>';
    }
}
