<?php


add_action('rest_api_init', function () {
    register_rest_route('zoobin/v1', '/products', [
        'methods'  => 'GET',
        'callback' => 'myapi_get_products',
    ]);
});

function myapi_get_products(WP_REST_Request $request)
{
    $pageNumber = intval($request->get_param('pageNumber')) ?: 1;
    $pageSize   = intval($request->get_param('pageSize')) ?: 10;

    $args = [
        'post_type'      => 'product',
        'post_status'    => 'publish',
        'posts_per_page' => $pageSize,
        'paged'          => $pageNumber,
        'orderby'        => 'date',
        'order'          => 'DESC'
    ];

    $query  = new WP_Query($args);
    $result = [];

    foreach ($query->posts as $post) {

        $product = wc_get_product($post->ID);
        if (!$product) continue;

        $globalGuarantee = get_post_meta($product->get_id(), 'dina_public_meta_value_one', true);

        $productData = [
            "id"           => (string)$product->get_id(),
            "title"        => $product->get_name(),
            "url"          => get_permalink($product->get_id()),
            "currency"     => "IRT",
            "purchaseItems"=> []
        ];


        if ($product->is_type('simple')) {

            $color    = $product->get_attribute('color-selector');
            $guranti  = $product->get_attribute('guranti');

            $finalGuarantee = $guranti ?: $globalGuarantee;

            $productData["purchaseItems"][] = [
                "price"        => (int)$product->get_price(),
                "guarantee"    => $finalGuarantee ?: null,
                "availability" => $product->is_in_stock() ? "instock" : "outofstock"
            ];
        }


        if ($product->is_type('variable')) {

            $variations = $product->get_children();

            foreach ($variations as $varID) {

                $variation = wc_get_product($varID);
                if (!$variation) continue;

                $color    = $variation->get_attribute('color-selector');
                $guranti  = $variation->get_attribute('guranti');

                $finalGuarantee = $guranti ?: $globalGuarantee;

                $productData["purchaseItems"][] = [
                    "price"        => (int)$variation->get_price(),
                    "color"        => $color ?: null,
                    "guarantee"    => $finalGuarantee ?: null,
                    "availability" => $variation->is_in_stock() ? "instock" : "outofstock"
                ];
            }
        }

        $result[] = $productData;
    }

    return [
        "pageNumber" => $pageNumber,
        "pageSize"   => $pageSize,
        "totalPages" => $query->max_num_pages,
        "products"   => $result
    ];
}
