<?php


if (!defined('ABSPATH')) exit;

add_shortcode('mobile_order_tracking', 'mot_render_tracking_form');

add_action('wp_head', function(){
    ?>
    <style>
        .ots-wrapper {
            max-width: 440px;
            margin: 40px auto;
            padding: 24px;
            background: #ffffff;
            border-radius: 18px;
            box-shadow: 0 15px 40px rgba(0,0,0,.08);
            font-family: inherit;
        }
        .ots-wrapper h3 {
            text-align: center;
            margin-bottom: 18px;
        }
        .ots-wrapper input {
            width: 100%;
            padding: 14px;
            border-radius: 12px;
            border: 1px solid #ddd;
            margin-bottom: 14px;
            font-size: 15px;
        }
        .ots-wrapper button {
            width: 100%;
            padding: 14px;
            border-radius: 12px;
            border: none;
            background: #2563eb;
            color: #fff;
            font-size: 16px;
            cursor: pointer;
        }
        .ots-result {
            margin-top: 22px;
            padding: 18px;
            background: #f9fafb;
            border-radius: 14px;
        }
        .ots-status {
            display: inline-block;
            padding: 6px 16px;
            border-radius: 30px;
            background: #dbeafe;
            color: #1e40af;
            font-size: 13px;
        }
        .ots-error {
            background: #fee2e2;
            color: #991b1b;
            padding: 14px;
            border-radius: 12px;
            margin-top: 18px;
        }
        .ots-result ul {
            padding-left: 20px;
        }
    </style>
    <?php
});

function mot_render_tracking_form() {
    if(!class_exists('WooCommerce')) return '<p class="ots-error">ووکامرس فعال نیست!</p>';

    ob_start();
    ?>
    <div class="ots-wrapper">
        <h3>رهگیری سفارش</h3>
        <form method="post">
            <input type="text" name="ots_phone" placeholder="شماره موبایل خود را وارد کنید" required>
            <button type="submit" name="ots_submit">رهگیری سفارش</button>
        </form>

        <?php
        if(isset($_POST['ots_submit'])) {

            $phone = sanitize_text_field($_POST['ots_phone']);

            if(empty($phone)) {
                echo '<div class="ots-error">لطفاً شماره موبایل را وارد کنید.</div>';
            } else {

                $orders = wc_get_orders(array(
                    'limit'      => -1,
                    'meta_key'   => '_billing_phone',
                    'meta_value' => $phone,
                ));

                if(!empty($orders)) {
                    echo '<div class="ots-result">';
                    echo '<ul>';
                    foreach($orders as $order) {
                        echo '<li>';
                        echo 'شماره سفارش: #' . $order->get_id() . '<br>';
                        echo 'تاریخ: ' . wc_format_datetime($order->get_date_created()) . '<br>';
                        echo 'مبلغ: ' . wc_price($order->get_total()) . '<br>';
                        echo 'وضعیت: <span class="ots-status">' . wc_get_order_status_name($order->get_status()) . '</span>';
                        echo '</li>';
                    }
                    echo '</ul>';
                    echo '</div>';
                } else {
                    echo '<div class="ots-error">هیچ سفارشی با این شماره موبایل یافت نشد.</div>';
                }

            }
        }
        ?>
    </div>
    <?php
    return ob_get_clean();
}
