<?php

add_action('template_redirect', 'redirect_checkout_if_not_logged_in');
function redirect_checkout_if_not_logged_in() {

    // آیدی صفحه تسویه حساب
    $checkout_page_id = get_option('woocommerce_checkout_page_id');

    // اگر کاربر لاگین نیست و وارد صفحه تسویه حساب شده
    if (!is_user_logged_in() && is_page($checkout_page_id)) {

        // آدرس صفحه تسویه حساب
        $checkout_url = get_permalink($checkout_page_id);

        // ساختن لینک صفحه ورود (حساب کاربری) همراه با redirect_to
        $redirect_url = add_query_arg(
            'redirect_to',
            urlencode($checkout_url),
            site_url('/my-account/')
        );

        wp_redirect($redirect_url);
        exit;
    }

    // اگر کاربر وارد شده و داخل صفحه my-account است
    if (is_user_logged_in() && is_page(get_option('woocommerce_myaccount_page_id'))) {

        // اگر redirect_to در URL وجود داشته باشد
        if (!empty($_GET['redirect_to'])) {

            $redirect_to = esc_url_raw($_GET['redirect_to']);

            wp_redirect($redirect_to);
            exit;
        }
    }
}
