<?php

/**
 * Compatibility - WooCommerce Multi Currency.
 * 
 * @since 8.5
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('FGF_WC_Multi_Currency_Compatibility')) {

	/**
	 * Class.
	 */
	class FGF_WC_Multi_Currency_Compatibility extends FGF_Compatibility {

		/**
		 * Class Constructor.
		 */
		public function __construct() {
			$this->id = 'wc_multi_currency';

			parent::__construct();
		}

		/**
		 * Is plugin enabled?.
		 * 
		 *  @return bool
		 * */
		public function is_plugin_enabled() {
			return function_exists('wmc_get_price');
		}

		/**
		 * Frontend Action.
		 */
		public function frontend_action() {
			// Convert the price based on current currency. 
			add_filter('fgf_convert_price_to_current_currency', array( $this, 'convert_price_to_current_currency' ), 10, 1);
			// Convert the price based on default currency. 
			add_filter('fgf_rule_total_price', array( $this, 'convert_price_to_default_currency' ), 11, 1);
		}

		/**
		 * Convert the price based on current currency.
		 *
		 * @since 12.5.0
		 * @param int|float $price Price.
		 * @return int|float
		 */
		public static function convert_price_to_current_currency( $price ) {
			return self::convert_price($price);
		}

		/**
		 * Convert the price based on default currency.
		 *
		 * @since 12.5.0
		 * @param int|float $price Price.
		 * @return int|float
		 */
		public static function convert_price_to_default_currency( $price ) {
			return self::convert_price($price, true);
		}

		/**
		 * Convert the price based on current currency.
		 *
		 * @since 12.5.0
		 * @param int|float $price Price.
		 * @param bool      $convert_to_default_currency Whether to convert the price to the default currency or not.
		 * @return int|float
		 */
		public static function convert_price( $price, $convert_to_default_currency = false ) {
			if ( ! $price ) {
				return $price;
			}

			if ( $convert_to_default_currency ) {
				return wmc_revert_price($price);
			}

			return wmc_get_price( $price );
		}
	}

}
