<?php
defined('ABSPATH') || die;

class PC_Assemble_Admin_Rest extends Pa_Assemble
{
	public function __construct ()
	{
		add_filter( 'rest_api_init', [$this, 'admin_rest'] );
	}

	function admin_rest()
	{
		register_rest_route( 'pa', '/changeSectionStatus', array(
			'methods' => 'POST',
			'callback' => [$this, 'pc_assemble_change_section_status'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
		));

		register_rest_route( 'pa', '/changeSectionOrder', array(
			'methods' => 'POST',
			'callback' => [$this, 'pc_assemble_change_section_order'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
		));

		register_rest_route( 'pa', '/changeCategoryStatus', array(
			'methods' => 'POST',
			'callback' => [$this, 'pc_assemble_change_category_status'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
		));

		register_rest_route( 'pa', '/changeCategoryOrder', array(
			'methods' => 'POST',
			'callback' => [$this, 'pc_assemble_change_category_order'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
		));

		register_rest_route( 'pa', '/changeRelationStatus', array(
			'methods' => 'POST',
			'callback' => [$this, 'pc_assemble_change_relation_status'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
		));

		register_rest_route( 'pa', '/getAttributeTerms', array(
			'methods' => 'get',
			'callback' => [$this, 'pc_assemble_get_attribute_terms'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
		));
	}

	public function pc_assemble_get_attribute_terms ($data)
	{
		$attr = wc_get_attribute( sanitize_text_field( $data['attr'] ) );
		return get_terms( ['taxonomy' => $attr->slug, 'hide_empty' => false ]);
	}

	public function pc_assemble_change_section_status ( $data )
	{
		$status = $data['status'] == 'true' ? 1 : 0;

		parent::$wpdb->update( 
			parent::$sections_table, 
			[ 'status' => $status ], 
			['id' => sanitize_text_field( $data['id'] ) ] 
		);
	}

	public function pc_assemble_change_section_order ( $data )
	{
		global $wpdb;
		$table = parent::$sections_table;

		$ids = join("','", sanitize_text_field( $data['newOrder'] ));  

		$new = $wpdb->get_results("select * from $table where id in ('$ids') order by field(id,'$ids')");

		$delete = $wpdb->delete( $table, [ 'parent' => 0 ]);

		$new_ids = [];

		foreach ( $new as $key=>$item )
		{
			$item = (array) $item;
			$last_id = $item['id'];
			unset($item['id']);
			$wpdb->insert( $table, $item);
			$wpdb->update( $table, ['parent' => $wpdb->insert_id],['parent' => $last_id] );
			$new_ids[] = $wpdb->insert_id;
		}

		return $new_ids;
	}

	function pc_assemble_change_category_order($data)
	{
		global $wpdb;
		$table = parent::$sections_table;

		$ids = join("','", $data['newOrder']);  

		$new = $wpdb->get_results("select * from $table where id in ('$ids') order by field(id,'$ids')");

		$delete = $wpdb->query("delete from $table where id in ('$ids')");

		$new_ids = [];

		foreach ( $new as $key=>$item )
		{
			$item = (array) $item;
			unset($item['id']);
			$wpdb->insert( $table, $item);
			$new_ids[] = $wpdb->insert_id;
		}

		return $new_ids;
	}

	function pc_assemble_change_category_status ( $data )
	{
		$status = $data['status'] == 'true' ? 1 : 0;

		parent::$wpdb->update( parent::$sections_table, [ 'status' => $status ], ['id' => sanitize_text_field( $data['id'] ) ] );
	}

	function pc_assemble_change_relation_status ( $data )
	{
		$status = $data['status'] == 'true' ? 1 : 0;

		parent::$wpdb->update( 
			parent::$relations_table, 
			[ 'status' => $status ], 
			['id' => sanitize_text_field( $data['id'] ) ] 
		);

		return $status;
	}
}

new PC_Assemble_Admin_Rest();