<?php
defined( 'ABSPATH' ) || exit;

class PC_Assemble_Admin extends Pa_Assemble
{
	public function __construct ()
	{
		$this->pc_assemble_define_constants();
		$this->pc_assemble_includes();
		$this->pc_assemble_init();
	}

	protected function pc_assemble_define_constants()
	{
		$this->define( 'PA_ADMIN_PARTIALS', dirname( __FILE__ ) . '/partials/' );
		$this->define( 'PA_ADMIN_ASSETS', plugin_dir_url( __FILE__ ) );
		$this->define( 'PA_ADMIN', PA_BASE . '/admin/' );
		$this->define( 'PA_ADMIN_URL', PA_BASE_URL . '/admin' );
	}

	protected function pc_assemble_includes()
	{
		require_once PA_ADMIN_PARTIALS . 'class-pa-enqueue.php';
		require_once PA_ADMIN_PARTIALS . 'class-pa-post-types.php';
	}

	protected function pc_assemble_init()
	{
		add_action( 'admin_menu', [$this, 'pc_assemble_admin_menu'] );
		add_action( 'admin_notices', [$this, 'pc_assemble_admin_notices'] );
	}

	public function pc_assemble_admin_notices ()
	{
		global $pagenow;
		
		if ( ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'pcassemble' ) || ( isset( $_GET['page'] ) && $_GET['page'] == 'pa-settings' )  )
		{
			$main_product = get_option('pa_main_product', '');
			
			$product = wc_get_product( $main_product );

			if ( $main_product == '' )
			{
				$err = __( "PC Assemble Pro: The main product is not selected. This makes your users unable to register assembly orders.", "assemble" ) . '<a href="'.admin_url("/edit.php?post_type=pcassemble&page=pa-settings").'"> '.esc_html__( "Go to settings", "assemble" ).'</a>';
			}
			else if ( ! $product ) 
			{
				$err = __( "PC Assemble Pro: The selected main product is not exists and not selected. This makes your users unable to register assembly orders.", "assemble" ) . '<a href="'.admin_url("/edit.php?post_type=pcassemble&page=pa-settings").'"> '.esc_html__( "Go to settings", "assemble" ).'</a>';
			}
			else if ( $product && $product->get_status() == 'trash' )
			{
				$err = __( "PC Assemble Pro: The selected main product is in trash. This makes your users unable to register assembly orders.", "assemble" ) . '<a href="'.admin_url("/edit.php?post_type=pcassemble&page=pa-settings").'"> '.esc_html__( "Go to settings", "assemble" ).'</a>';
			}
			else if ( $product && $product->get_price() == '' ) 
			{
				$url = admin_url("/post.php?post={$main_product}&action=edit");
				$err = __( "PC Assemble Pro: The main product price is empty. insert 0 for main product. This makes your users unable to register assembly orders.", "assemble" ) . '<a href="'.$url.'"> '.esc_html__( "Go to main product", "assemble" ).'</a>';
			}

			if ( isset( $err ) )
			{
				echo '<div class="notice notice-error pc_assemble_notice">
					<p> <strong> '.$err.'</strong></p>
				</div>';
			}
		}
	}

	public function pc_assemble_admin_menu()
	{
		add_submenu_page(
			'edit.php?post_type=pcassemble',
			__( 'Settings', 'assemble' ),
			__( 'Settings', 'assemble' ),
			'manage_options',
			'pa-settings',
			[$this, 'pc_assemble_settings']
		);
	}

	public function pc_assemble_settings()
	{
		$this->pc_assemble();

	    require dirname(__FILE__) . '/partials/class-pa-settings.php';
	}

	protected function pc_assemble()
	{
		if( self::pc_assemble_encrypt_decrypt('decrypt', get_option('assemble_li3nce', 0) ) != 
		preg_replace('/^www\./', '', sanitize_text_field( $_SERVER['SERVER_NAME'] ) ) )
		{
			wp_die( esc_html__('Your domain is not registered. To do this, go to the site where you bought the plugin and enter the user panel. Go to the orders and order details section and register your domain there.', 'assemble') );
		}
	}

	function pc_assemble_encrypt_decrypt($action, $string) 
    {
        $output = false;
        $encrypt_method = "AES-256-CBC";
        $secret_key = 'M`zL<*@vUw>)p5xq$HD/~P341';
        $secret_iv = 'G5>eTY4cV~p(+MWJ}g!Cq,231';
        $key = hash('sha256', $secret_key);
    
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ( $action == 'encrypt' ) 
        {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } 
        else if( $action == 'decrypt' ) 
        {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }
}

new PC_Assemble_Admin();