<?php
class PC_Assemble_Admin_Enqueue extends PC_Assemble_Admin
{
	public function __construct()
	{
		$this->init();
	}

	public function init()
	{
		add_action( 'admin_enqueue_scripts', [$this, 'pc_assemble_enqueue_styles'] );
		add_action( 'admin_enqueue_scripts', [$this, 'pc_assemble_enqueue_scripts'] );
		add_action( 'admin_head', [$this, 'pc_assemble_admin_head'] );
	}

	public function pc_assemble_enqueue_styles($screen) 
	{
		global $post_type;

		if ( $screen == 'pcassemble_page_pa-settings' || ( $screen == 'post.php' && $post_type == 'pcassemble' ) || ( $screen == 'post-new.php' && $post_type == 'pcassemble' ) )
		{

			wp_enqueue_style( 
				'select2-css', PA_ADMIN_ASSETS . 'css/pa_select2.css', 
				array(), PA_VERSION
			);

			wp_enqueue_style( 
				PA_NAME, PA_ADMIN_ASSETS . 'css/pa_admin.css', 
				array(), PA_VERSION 
			);

			if ( is_rtl() ) 
			{
				wp_enqueue_style( 
					'pa-admin-rtl', PA_ADMIN_ASSETS . 'css/pa_admin_rtl.css', array(), PA_VERSION 
				);
			}

		}
			
	}

	public function pc_assemble_enqueue_scripts($screen) 
	{
		global $post_type;
		
		if ( $screen == 'pcassemble_page_pa-settings' || ( $screen == 'post.php' && $post_type == 'pcassemble' ) || ( $screen == 'post-new.php' && $post_type == 'pcassemble' ) )
		{

			wp_enqueue_media();

			wp_enqueue_script( 
				PA_NAME, PA_ADMIN_ASSETS . 'js/pa_admin.js', 
				array( 'jquery' ), null, false 
			);

			wp_localize_script( PA_NAME, 'pa', [
			'home'   => home_url(),
			'admin'  => admin_url(),
			'nonce'  => wp_create_nonce('wp_rest'),
			'error_one_select_limit' => __('Considering that you have included a single selection for this category in the section settings, it is not possible to select more than one product.', 'assemble')
			] );

			wp_enqueue_script(
				'pa-jqueryui', PA_ADMIN_ASSETS . 'js/jquery-ui.min.js', 
				array(), null, false
			);

			wp_enqueue_script(
				'pa-select2', PA_ADMIN_ASSETS . 'js/pa_select2.js', 
				array(), null, false
			);

		}
	}

	public function pc_assemble_admin_head ()
	{
		if ( isset( $_GET['page'] ) && $_GET['page'] != 'pa-settings' ) return;

		if ( is_rtl() ) return;

		?>
		
		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400&display=swap" rel="stylesheet">

		<?php
	}
}

new PC_Assemble_Admin_Enqueue();