<?php 
class PC_Assemble_Settings_Sections extends PC_Assemble_Settings
{
	protected $section;
	protected $categories;

	function __construct()
	{
		$this->pc_assemble_controller();
		
		$this->pc_assemble_template_loader( '/settings/templates/categories.php' );
	}

	private function pc_assemble_controller()
	{
		if( isset($_POST['pa_add_category']) ) 
		{
			$this->pc_assemble_add_categoryr();
		}

		if( isset( $_GET['action'] ) && 'delete' == $_GET['action'])
		{ 
			$this->pc_assemble_delete_category();
		}

		$this->section = $this->pc_assemble_get_section();

		$this->categories = $this->pc_assemble_get_categories();
	}

	private function pc_assemble_get_section() 
	{
		$section_id = sanitize_text_field( $_GET['section'] );
		$table = parent::$sections_table;

		$section = parent::$wpdb->get_row("select * from $table where id={$section_id} order by id");
		
		return isset($section->name) ? $section->name : false;
	}

	private function pc_assemble_category_select ( $select )
	{
		if( 'single' == $select ) 
		{
			return esc_html__('Single', 'assemble');
		}

		if( 'multiple' == $select ) 
		{
			return esc_html__('Multiple', 'assemble');
		}

		return '';
	}

	private function pc_assemble_category_display ( $display )
	{
		switch( $display ) 
		{
			case 'all':
				return esc_html__('All', 'assemble');
			break;
			case 'available':
				return esc_html__('Available', 'assemble');
			break;
			default:
				return '---';
		}
	}

	private function pc_assemble_category_order ( $order )
	{
		switch( $order ) 
		{
			case 'asc-date':
				return esc_html__('Asc Date', 'assemble');
			break;
			case 'desc-date':
				return esc_html__('Desc Date', 'assemble');
			break;
			case 'asc-price':
				return esc_html__('Asc Price', 'assemble');
			break;
			case 'desc-price':
				return esc_html__('Desc Price', 'assemble');
			break;
			case 'top-sale':
				return esc_html__('Top Sale', 'assemble');
			break;
			default:
				return '---';
		}
	}

	private function pc_assemble_add_categoryr()
	{
		$select = $_POST['pa_category_select'] == '' ? 'single' : sanitize_text_field( $_POST['pa_category_select'] );

		if( $_POST['pa_category_id'] == '' ) 	
		{
			parent::$wpdb->insert(parent::$sections_table, [
				'name' 			=> sanitize_text_field( $_POST['pa_category_title'] ),
				'category' 		=> sanitize_text_field( $_POST['pa_category'] ),
				'parent' 		=> sanitize_text_field( $_POST['pa_current_section'] ),
				'display' 		=> sanitize_text_field( $_POST['pa_category_display'] ),
				'pa_order' 		=> sanitize_text_field( $_POST['pa_category_order'] ),
				'pa_select' 	=> sanitize_text_field( $select ),
				'stock_limit' 	=> sanitize_text_field( $_POST['pa_category_stock_limit'] ),
				'mandatory' 	=> sanitize_text_field( $_POST['pa_category_mandatory'] ),
			]);
		}
		else 
		{
			parent::$wpdb->update(parent::$sections_table, [
				'name' 		=> sanitize_text_field( $_POST['pa_category_title'] ),
				'category' 	=> sanitize_text_field( $_POST['pa_category'] ),
				'display' 	=> sanitize_text_field( $_POST['pa_category_display'] ),
				'pa_order' 	=> sanitize_text_field( $_POST['pa_category_order'] ),
				'pa_select' => sanitize_text_field( $select ),
				'stock_limit' 	=> sanitize_text_field( $_POST['pa_category_stock_limit'] ),
				'mandatory' 	=> sanitize_text_field( $_POST['pa_category_mandatory'] ),
			],[
				'id'		=> sanitize_text_field( $_POST['pa_category_id'] )
			]);
		}
		
	}

	private function pc_assemble_get_categories() 
	{
		$table = parent::$sections_table;
		$section_id = sanitize_text_field( $_GET['section'] );

		$categories = parent::$wpdb->get_results("select * from $table where parent={$section_id} order by id asc");
		$output = '';
		
		foreach( $categories as $category ) 
		{
			$cat = get_term($category->category);
			$output.= '<tr class="ui-sortable-handle" data-id="'.esc_attr($category->id).'">';
				$output.= '<td><span class="dashicons dashicons-menu"></span> '.esc_html($category->name).'</td>';
				$output.= '<td>'.esc_html($cat->name).'</td>';
				$output.= '<td>'.$this->pc_assemble_category_display($category->display).'</td>';
				$output.= '<td>'.$this->pc_assemble_category_order($category->pa_order).'</td>';
				$output.= '<td>'.$this->pc_assemble_category_select($category->pa_select).'</td>';
				$stock_limit = $category->stock_limit == 1 ? '<span class="dashicons dashicons-saved"></span>' : '<span class="dashicons dashicons-no-alt"></span>';
				$output .= '<td class="text-center">'.$stock_limit.'</td>';
				$mandatory = $category->mandatory == 1 ? '<span class="dashicons dashicons-saved"></span>' : '<span class="dashicons dashicons-no-alt"></span>';
				$output .= '<td class="text-center">'.$mandatory.'</td>';
				$output.= '<td class="text-center">';
					$output.= '<a class="delete_category" href="admin.php?page=pa-settings&tab=categories&section='.sanitize_text_field($_GET["section"]).'&action=delete&id='.esc_attr($category->id).'">';
					$output.= '<span class="dashicons dashicons-trash"></span>';
					$output.= '</a>';
					$output.= ' &nbsp; <span class="dashicons dashicons-edit pa_edit_category_btn"></span>';
					$output.= '<input type="hidden" class="id" value="'.esc_attr($category->id).'" />';
					$output.= '<input type="hidden" class="name" value="'.esc_attr($category->name).'" />';
					$output.= '<input type="hidden" class="category" value="'.esc_attr($category->category).'" />';
					$output.= '<input type="hidden" class="parent" value="'.esc_attr($category->parent).'" />';
					$output.= '<input type="hidden" class="display" value="'.esc_attr($category->display).'" />';
					$output.= '<input type="hidden" class="pa_order" value="'.esc_attr($category->pa_order).'" />';
					$output.= '<input type="hidden" class="pa_select" value="'.esc_attr($category->pa_select).'" />';
					$output.= '<input type="hidden" class="status" value="'.esc_attr($category->status).'" />';
					$output.= '<input type="hidden" class="stock_limit" value="'.esc_attr($category->stock_limit).'" />';
					$output.= '<input type="hidden" class="mandatory" value="'.esc_attr($category->mandatory).'" /></td>';
				$output.= '<td class="text-center"><label class="switch">';
				$checked = $category->status == 1 ? 'checked="checked"' : '';
				$output.= '<input class="pa_category_status" value="1" type="checkbox" data-id="'.esc_attr($category->id).'" '.$checked.'>';
				$output.= '<span class="slider round"></span></label></td>';
			$output.= '</tr>';
		}
		
		return $output;
		
	}

	private function pc_assemble_delete_category()
	{
		parent::$wpdb->delete(parent::$sections_table, [ 'id' => sanitize_text_field( $_GET['id'] ) ]);

		wp_redirect(admin_url() . 'admin.php?page=pa-settings&tab=categories&section='.sanitize_text_field( $_GET['section'] ) );
		exit;
	}
}

new PC_Assemble_Settings_Sections();