<?php
$page = isset($_GET['tab']) ? sanitize_text_field( $_GET['tab'] ) : 'pa_general';
?>

<div id="pc_tabs_wrapper" class="<?php echo 'pa_'.$page; ?>">
	<h3>
		<a href="admin.php?page=pa-settings&tab=sections" class="pa_return_back_a"><span class="pa_return_back"><span class="dashicons dashicons-arrow-left-alt"></span></span></a><?php esc_html_e('Categories Of', 'assemble'); ?> <?php echo esc_html($this->section); ?>
		<button type="button" class="pa_add_category_btn"><?php esc_html_e('Add New Category', 'assemble'); ?></button>
	</h3>
	
	<table id="pa_sections" class="pa_category">
		<thead>
			<tr draggable="true">
				<th style="width: 20%"><?php esc_html_e('Title', 'assemble'); ?></th>
				<th style="width: 15%"><?php esc_html_e('Category', 'assemble'); ?></th>
				<th style="width: 10%"><?php esc_html_e('Display', 'assemble'); ?></th>
				<th style="width: 10%"><?php esc_html_e('Order', 'assemble'); ?></th>
				<th style="width: 10%"><?php esc_html_e('Select', 'assemble'); ?></th>
				<th style="width: 10%" class="text-center"><?php esc_html_e('Stock Limit', 'assemble'); ?></th>
				<th style="width: 10%" class="text-center"><?php esc_html_e('Mandatory', 'assemble'); ?></th>
				<th style="width: 20%" class="text-center"><?php esc_html_e('Actions', 'assemble'); ?></th>
				<th style="width: 10%" class="text-center"><?php esc_html_e('Status', 'assemble'); ?></th>
			</tr>
		</thead>
		
		<tbody>
			<?php 
			echo $this->categories;
			?>
		</tbody>
	</table>

	<div class="pa_tab_wrapper">
		<div class="pa_tab">
			<h2>
			<strong class="pa_add_category_title"><?php esc_html_e('Add Category', 'assemble'); ?></strong>
			<strong class="pa_edit_category_title"><?php esc_html_e('Edit Category', 'assemble'); ?></strong>
			<span class="pa_close_category_modal"><span class="dashicons dashicons-no-alt"></span>
			</h2>

			<form method="post" id="add_category_form">

				<input type="hidden" name="pa_current_section" id="pa_current_section" value="<?php echo esc_attr($_GET['section']); ?>" />

				<input type="hidden" name="dlr_nonce" value="<?php echo esc_attr( wp_create_nonce('pa-nonce') ); ?>" />

				<div class="pa_form_section">
					<label for="pa_category_title"><span class="pc_assemble_star">*</span> <?php esc_html_e('Title', 'assemble'); ?></label>
					<input id="pa_category_title" autocomplete="off" required type="text" name="pa_category_title" />
					<input type="hidden" name="pa_category_id" value="" />
				</div>

				<?php $categories = get_terms( ['taxonomy' => 'product_cat', 'hide_empty' => false] ); ?>

				<div class="pa_form_section">
					<label for="pa_category"><span class="pc_assemble_star">*</span> <?php esc_html_e('Category', 'assemble'); ?></label>
					<select id="pa_category" required name="pa_category">
					<option value=""></option>
					<?php foreach($categories as $cat) {
						echo '<option value="'.esc_attr($cat->term_id).'">'.esc_html($cat->name).'</option>';
					}
					?>
					</select>
				</div>

				<div class="pa_form_section">
					<label for="pa_category_display"><?php esc_html_e('Display', 'assemble'); ?></label>
					<select id="pa_category_display" name="pa_category_display">
						<option value="0"><?php esc_html_e('Nothing', 'assemble'); ?></option>
						<option value="all"><?php esc_html_e('All', 'assemble'); ?></option>
						<option value="available"><?php esc_html_e('Available', 'assemble'); ?></option>
					</select>
				</div>

				<div class="pa_form_section">
					<label for="pa_category_order"><?php esc_html_e('Order', 'assemble'); ?></label>
					<select id="pa_category_order" name="pa_category_order">
						<option value="0"><?php esc_html_e('Nothing', 'assemble'); ?></option>
						<option value="asc-date"><?php esc_html_e('Asc Date', 'assemble'); ?></option>
						<option value="desc-date"><?php esc_html_e('Desc Date', 'assemble'); ?></option>
						<option value="asc-price"><?php esc_html_e('Asc Price', 'assemble'); ?></option>
						<option value="desc-price"><?php esc_html_e('Desc Price', 'assemble'); ?></option>
						<option value="top-sale"><?php esc_html_e('Top Sale', 'assemble'); ?></option>
					</select>
				</div>

				<div class="pa_form_section">
					<label for="pa_category_select"><?php esc_html_e('Select', 'assemble'); ?></label>
					<select id="pa_category_select" name="pa_category_select">
						<option value="single"><?php esc_html_e('Single', 'assemble'); ?></option>
						<option value="multiple"><?php esc_html_e('Multiple', 'assemble'); ?></option>
					</select>
				</div>

				<div class="pa_form_section">
					<label for="pa_category_stock_limit"><?php esc_html_e('Limit by stock', 'assemble'); ?></label>
					<select id="pa_category_stock_limit" name="pa_category_stock_limit">
						<option value="0"><?php esc_html_e('No', 'assemble'); ?></option>
						<option value="1"><?php esc_html_e('Yes', 'assemble'); ?></option>
					</select>
				</div>

				<div class="pa_form_section">
					<label for="pa_category_mandatory"><?php esc_html_e('Mandatory', 'assemble'); ?></label>
					<select id="pa_category_mandatory" name="pa_category_mandatory">
						<option value="0"><?php esc_html_e('No', 'assemble'); ?></option>
						<option value="1"><?php esc_html_e('Yes', 'assemble'); ?></option>
					</select>
				</div>

				<div class="pa_submit_box">
					<input value="<?php esc_html_e('Save', 'assemble'); ?>" type="submit" name="pa_add_category" />
				</div>

			</form>
		</div>
	</div>

</div>