<?php 
$options = unserialize($this->current_options['_pa_design_settings']); 

$page = isset($_GET['tab']) ? sanitize_text_field( $_GET['tab'] ) : 'pa_general';
?>

<form method="post" action="" class="<?php echo 'pa_'.esc_attr($page); ?>">

<ul class="pa_design_tabs">
	<li><a href="#general" class="active"><?php esc_html_e('General', 'assemble'); ?></a></li>
	<li><a href="#categories"><?php esc_html_e('Categories', 'assemble'); ?></a></li>
	<li><a href="#tab"><?php esc_html_e('Tab', 'assemble'); ?></a></li>
	<li><a href="#summary"><?php esc_html_e('Summary', 'assemble'); ?></a></li>
	<li><a href="#add_to_cart"><?php esc_html_e('Add To cart Button', 'assemble'); ?></a></li>
	<li><a href="#required_error"><?php esc_html_e('Required Error', 'assemble'); ?></a></li>
	<li><a href="#social_icons"><?php esc_html_e('Social Icons', 'assemble'); ?></a></li>
</ul>

<input type="hidden" name="pa_nonce" value="<?php echo esc_attr( wp_create_nonce('pa-nonce') ); ?>" />

<table class="form-table">
	<tbody>

<tr class="pa_general general active">
	<th><?php esc_html_e('Page Background Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['background_color']) ? esc_attr($options['background_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[background_color]" />
		<p><?php esc_html_e("Specifies the background color of the page", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general general active">
	<th><?php esc_html_e('Page Background Image', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['background_image']) ? esc_attr($options['background_image']) : ''; ?>" type="text" placeholder="" class="select_media_box" name="_pa_design_settings[background_image]" />
		<button type="button" class="button button-secondary select_media"><?php esc_html_e('Select', 'assemble'); ?></button>
		<p><?php esc_html_e("Specifies the background image of the page", 'assemble'); ?></p>
	</td>
</tr>

<tr class="general active">
	<th class="swtich-th"><?php esc_html_e('Fix Page Background Image', 'assemble'); ?></th>
	<td>
		<label class="switch">
			<?php $fix_background_images = isset($options['fix_background_image']) ? $options['fix_background_image'] : ''; ?>
			<input name="_pa_design_settings[fix_background_image]" id="fix_background_image" type="checkbox" <?php checked( esc_attr($fix_background_images), 'on'); ?>>
			<span class="slider round"></span>
		</label>
		<p><?php esc_html_e("Fix backgound image of the page", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Categories Background Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['categories_background_color']) ? esc_attr($options['categories_background_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[categories_background_color]" />
		<p><?php esc_html_e("Specifies the background color of the categories (like #000)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Categories Background Image', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['categories_background_image']) ? esc_attr($options['categories_background_image']) : ''; ?>" type="text" placeholder="" class="select_media_box" name="_pa_design_settings[categories_background_image]" />
		<button type="button" class="button button-secondary select_media"><?php esc_html_e('Select', 'assemble'); ?></button>
		<p><?php esc_html_e("Specifies the background image of the categories", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Categories Border', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['categories_border']) ? esc_attr($options['categories_border']) : ''; ?>" type="text" placeholder="1px solid #555" name="_pa_design_settings[categories_border]" />
		<p><?php esc_html_e("Specifies the border of the categories (like 1px solid #000)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Categories Box Shadow', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['categories_box_shadow']) ? esc_attr($options['categories_box_shadow']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[categories_box_shadow]" />
		<p><?php esc_html_e("Specifies the box shadow of the categories (like 0 3px 15px #ccc)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Categories Item Hover Background', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['categories_item_hover_background']) ? esc_attr($options['categories_item_hover_background']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[categories_item_hover_background]" />
		<p><?php esc_html_e("Specifies background of the item hover (like #333)", 'assemble'); ?></p>
	</td>
</tr>


<tr class="pa_general categories">
	<th><?php esc_html_e('Category Title Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_title_color']) ? esc_attr($options['category_title_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_title_color]" />
		<p><?php esc_html_e("Specifies color of category title (like #333)", 'assemble'); ?></p>
	</td>
</tr>


<tr class="pa_general categories">
	<th><?php esc_html_e('Category Title Font-Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_title_font_size']) ? esc_attr($options['category_title_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_title_font_size]" />
		<p><?php esc_html_e("Specifies font size of the category title (like 14px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Category Item Selected Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_item_selected_color']) ? esc_attr($options['category_item_selected_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_item_selected_color]" />
		<p><?php esc_html_e("Specifies color of category item selected (like #333)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Category Item Selected Font-Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_item_selected_font_size']) ? esc_attr($options['category_item_selected_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_item_selected_font_size]" />
		<p><?php esc_html_e("Specifies font size of the category item selected (like 14px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Category Item Border Bottom', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_item_border_bottom']) ? esc_attr($options['category_item_border_bottom']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_item_border_bottom]" />
		<p><?php esc_html_e("Specifies border bottom of the category item (like 1px solid #555)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Category Not Selected Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_not_selected_color']) ? esc_attr($options['category_not_selected_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_not_selected_color]" />
		<p><?php esc_html_e("Specifies color of not selected text (like #333)", 'assemble'); ?></p>
	</td>
</tr>


<tr class="pa_general categories">
	<th><?php esc_html_e('Category Not Selected Font-Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_not_selected_font_size']) ? esc_attr($options['category_not_selected_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_not_selected_font_size]" />
		<p><?php esc_html_e("Specifies font size of the not selected text (like 14px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general categories">
	<th><?php esc_html_e('Category Item Price Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_item_price_color']) ? esc_attr($options['category_item_price_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_item_price_color]" />
		<p><?php esc_html_e("Specifies color of category item price (like #333)", 'assemble'); ?></p>
	</td>
</tr>


<tr class="pa_general categories">
	<th><?php esc_html_e('Category Item Price Font-Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['category_item_price_font_size']) ? esc_attr($options['category_item_price_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[category_item_price_font_size]" />
		<p><?php esc_html_e("Specifies font size of the category item price (like 14px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="categories">
	<th class="swtich-th"><?php esc_html_e('Display Image Of Category', 'assemble'); ?></th>
	<td>
		<label class="switch">
			<?php $display_category_image = isset($options['display_category_image']) ? esc_attr($options['display_category_image']) : ''; ?>
			<input name="_pa_design_settings[display_category_image]" id="display_category_image" type="checkbox" <?php checked( esc_attr($display_category_image), 'on'); ?>>
			<span class="slider round"></span>
		</label>
		<p><?php esc_html_e("Display category of image", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general tab">
	<th><?php esc_html_e('Tab Background Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['tab_background_color']) ? esc_attr($options['tab_background_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[tab_background_color]" />
		<p><?php esc_html_e("Specifies the background color of the tabs (like #000 or black)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general tab">
	<th><?php esc_html_e('Tab Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['tab_color']) ? esc_attr($options['tab_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[tab_color]" />
		<p><?php esc_html_e("Specifies the border of tabs (like 1px solid #000)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general tab">
	<th><?php esc_html_e('Tab Border', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['tab_border']) ? esc_attr($options['tab_border']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[tab_border]" />
		<p><?php esc_html_e("Specifies the color of tabs (like #fff)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general tab">
	<th><?php esc_html_e('Tab Hover Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['tab_hover_color']) ? esc_attr($options['tab_hover_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[tab_hover_color]" />
		<p><?php esc_html_e("Specifies the hover color of tabs (like gold or #fff)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general tab">
	<th><?php esc_html_e('Tab Font Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['tab_font_size']) ? esc_attr($options['tab_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[tab_font_size]" />
		<p><?php esc_html_e("Specifies the font size of tabs (like 14px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Thumbnail Width', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['thumbnail_width']) ? esc_attr($options['thumbnail_width']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[thumbnail_width]" />
		<p><?php esc_html_e("Specifies the width size of thumbnail (like 250px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Product Summary Background Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['product_summary_background_color']) ? esc_attr($options['product_summary_background_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[product_summary_background_color]" />
		<p><?php esc_html_e("Specifies the background color of product summary (like #000)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Product Summary Border', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['product_summary_border']) ? esc_attr($options['product_summary_border']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[product_summary_border]" />
		<p><?php esc_html_e("Specifies the border of product summary (like 1px solid #ddd)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Product Summary Box Shadow', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['product_summary_box_shadow']) ? esc_attr($options['product_summary_box_shadow']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[product_summary_box_shadow]" />
		<p><?php esc_html_e("Specifies the box shadow of product summary (like 0 3px 10px #ddd)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Product Title Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['product_title_color']) ? esc_attr($options['product_title_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[product_title_color]" />
		<p><?php esc_html_e("Specifies the color of product title (like #333)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Product Title Font Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['product_title_font_size']) ? esc_attr($options['product_title_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[product_title_font_size]" />
		<p><?php esc_html_e("Specifies the font size of product title (like 20px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Total Price Text Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['total_price_text_color']) ? esc_attr($options['total_price_text_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[total_price_text_color]" />
		<p><?php esc_html_e("Specifies the color of total price text (like #333)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Total Price Text Font Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['total_price_text_font_size']) ? esc_attr($options['total_price_text_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[total_price_text_font_size]" />
		<p><?php esc_html_e("Specifies the font size of total price text (like 16px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Total Price Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['total_price_color']) ? esc_attr($options['total_price_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[total_price_color]" />
		<p><?php esc_html_e("Specifies the color of total price (like #333)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general summary">
	<th><?php esc_html_e('Total Price Font Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['total_price_font_size']) ? esc_attr($options['total_price_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[total_price_font_size]" />
		<p><?php esc_html_e("Specifies the font size of total price (like 16px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general add_to_cart">
	<th><?php esc_html_e('Add To Cart Button Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['add_to_cart_button_color']) ? esc_attr($options['add_to_cart_button_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[add_to_cart_button_color]" />
		<p><?php esc_html_e("Specifies the color of add to cart button (like #000)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general add_to_cart">
	<th><?php esc_html_e('Add To Cart Button Font Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['add_to_cart_button_font_size']) ? esc_attr($options['add_to_cart_button_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[add_to_cart_button_font_size]" />
		<p><?php esc_html_e("Specifies the font size of add to cart button (like 16px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general add_to_cart">
	<th><?php esc_html_e('Add To Cart Button Background', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['add_to_cart_button_background']) ? esc_attr($options['add_to_cart_button_background']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[add_to_cart_button_background]" />
		<p><?php esc_html_e("Specifies the background of add to cart button (like #ddd)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general add_to_cart">
	<th><?php esc_html_e('Add To Cart Button Padding', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['add_to_cart_button_padding']) ? esc_attr($options['add_to_cart_button_padding']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[add_to_cart_button_padding]" />
		<p><?php esc_html_e("Specifies the padding of add to cart button (like 5px or 5px 10px or 5px 10px 7px or 5px 10px 7px 8px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general add_to_cart">
	<th><?php esc_html_e('Add To Cart Button Hover Background', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['add_to_cart_button_hover_background']) ? esc_attr($options['add_to_cart_button_hover_background']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[add_to_cart_button_hover_background]" />
		<p><?php esc_html_e("Specifies the hover background of add to cart button (like #ddd)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general add_to_cart">
	<th><?php esc_html_e('Add To Cart Button Hover Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['add_to_cart_button_hover_color']) ? esc_attr($options['add_to_cart_button_hover_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[add_to_cart_button_hover_color]" />
		<p><?php esc_html_e("Specifies the hover color of add to cart button (like #000)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general required_error">
	<th><?php esc_html_e('Required Category Error Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['required_category_error_color']) ? esc_attr($options['required_category_error_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[required_category_error_color]" />
		<p><?php esc_html_e("Specifies the color of required error (like #fff)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general required_error">
	<th><?php esc_html_e('Required Category Error Font-Size', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['required_category_error_font_size']) ? esc_attr($options['required_category_error_font_size']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[required_category_error_font_size]" />
		<p><?php esc_html_e("Specifies the font size of required error (like 14px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general required_error">
	<th><?php esc_html_e('Required Category Error Border', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['required_category_error_border']) ? esc_attr($options['required_category_error_border']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[required_category_error_border]" />
		<p><?php esc_html_e("Specifies the border of required error (like 1px solid yellow)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general required_error">
	<th><?php esc_html_e('Required Category Error background', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['required_category_error_background']) ? esc_attr($options['required_category_error_background']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[required_category_error_background]" />
		<p><?php esc_html_e("Specifies the background of required error (like rgba(255,255,255,.1))", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general required_error">
	<th><?php esc_html_e('Required Category Error Items Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['required_category_error_items_color']) ? esc_attr($options['required_category_error_items_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[required_category_error_items_color]" />
		<p><?php esc_html_e("Specifies the color of required error items (like 1px solid yellow)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general social_icons">
	<th><?php esc_html_e('Social Icons Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['social_icon_color']) ? esc_attr($options['social_icon_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[social_icon_color]" />
		<p><?php esc_html_e("Specifies the color of social icons (like #fff)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general social_icons">
	<th><?php esc_html_e('Social Icons Background Color', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['social_icon_background_color']) ? esc_attr($options['social_icon_background_color']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[social_icon_background_color]" />
		<p><?php esc_html_e("Specifies the background color of social icons (like #000)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general social_icons">
	<th><?php esc_html_e('Social Icons Width', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['social_icon_width']) ? esc_attr($options['social_icon_width']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[social_icon_width]" />
		<p><?php esc_html_e("Specifies the width of social icons (like 36px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general social_icons">
	<th><?php esc_html_e('Social Icons Padding', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['social_icon_padding']) ? esc_attr($options['social_icon_padding']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[social_icon_padding]" />
		<p><?php esc_html_e("Specifies the padding of social icons (like 7px or 7px 10px or 7px 10px 5px or 7px 10px 5px 9px)", 'assemble'); ?></p>
	</td>
</tr>

<tr class="pa_general social_icons">
	<th><?php esc_html_e('Social Icons Border', 'assemble'); ?></th>
	<td>
		<input value="<?php echo isset($options['social_icon_border']) ? esc_attr($options['social_icon_border']) : ''; ?>" type="text" placeholder="" name="_pa_design_settings[social_icon_border]" />
		<p><?php esc_html_e("Specifies the border of social icons (like 1px solid #ddd)", 'assemble'); ?></p>
	</td>
</tr>


<tr class="submit_tr">
	<th><?php submit_button('', 'primary', 'pa_submit'); ?></th>
	<td></td>
</tr>

</tbody>
		</table>
	</form>
</div>

<script>
jQuery(document).ready(function($)
{
	var hash = window.location.hash;
	if ( hash != '' )
	{
		$('.pa_design_tabs a').removeClass('active');
		$('.pa_design_tabs a[href='+hash+']').addClass('active');
		hash = hash.substring(1);
		$('.pa_design tr').removeClass('active');
		$('.pa_design tr.'+hash).addClass('active');
		$('.submit_tr').addClass('active');
	}
})

</script>