<div id="pc_tabs_wrapper">
	<h3>
		<?php echo esc_html_e('All Relations', 'assemble'); ?>
		<button type="button" class="pa_add_relation_btn"><?php echo esc_html_e('Add New Relation', 'assemble'); ?></button>
	</h3>
	
	<table id="pa_sections" class="pa_section">
		<thead>
			<tr draggable="true">
				<th style="width: 11%"><?php echo esc_html_e('Relation Type', 'assemble'); ?></th>
				<th style="width: 11%"><?php echo esc_html_e('From Category', 'assemble'); ?></th>
				<th style="width: 11%"><?php echo esc_html_e('From Attribute', 'assemble'); ?></th>
				<th style="width: 12%"><?php echo esc_html_e('To Category', 'assemble'); ?></th>
				<th style="width: 11%"><?php echo esc_html_e('To Attribute', 'assemble'); ?></th>
				<th style="width: 11%"><?php echo esc_html_e('With Tag', 'assemble'); ?></th>
				<th style="width: 8%" class="text-center"><?php echo esc_html_e('Actions', 'assemble'); ?></th>
				<th style="width: 11%" class="text-center"><?php echo esc_html_e('Status', 'assemble'); ?></th>
			</tr>
		</thead>
		
		<tbody>
			<?php echo $this->relations; ?>
		</tbody>
	</table>

	<div class="pa_tab_wrapper pc_assemble_relations">
		<div class="pa_tab">
			
			<h2>
				<strong class="pa_add_relation_title"><?php echo esc_html_e('Add Relation', 'assemble'); ?></strong>
				<strong class="pa_edit_relation_title"><?php echo esc_html_e('Edit Relation', 'assemble'); ?></strong>
				<span class="pa_close_section_modal pa_close_relation_modal"><span class="dashicons dashicons-no-alt"></span>
			</h2>

			<form method="post">
			
				<input type="hidden" name="pa_relation_id" />

				<div class="max_wrapper">

				<div class="pa_form_section">
					<label for="pa_relation_type"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('Relation Type', 'assemble'); ?></label>
					<select id="pa_relation_type" name="pa_relation_type">
						<option></option>
						<option value="tag"><?php echo esc_html_e('Tag', 'assemble'); ?></option>
						<option value="attribute"><?php echo esc_html_e('Attribute', 'assemble'); ?></option>
					</select>
				</div>
				
				</div>


				<div class="pa_form_section pa_from_category">
					<label for="pa_from_category"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('From category', 'assemble'); ?></label>
					<select id="pa_from_category" name="pa_from_category">
						<option></option>
						<?php
						foreach( get_terms( 'product_cat', array( 'hide_empty' => false ) ) as $term )
							echo '<option value="'.esc_attr($term->term_id).'">'.esc_html($term->name).'</option>';
						?>
					</select>
				</div>

				<div class="pa_form_section pa_from_attribute">
					<label for="pa_from_attribute"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('From Attribute', 'assemble'); ?></label>
					<select id="pa_from_attribute" name="pa_from_attribute">
						<option></option>
						<?php
						foreach( wc_get_attribute_taxonomies() as $term )
							echo '<option value="'.esc_attr($term->attribute_id).'">'.esc_html($term->attribute_label).'</option>';
						?>
					</select>
				</div>

				<div class="pa_form_section pa_from_attribute_term">
					<label for="pa_from_attribute_term"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('From Attribute Term', 'assemble'); ?></label>
					<select id="pa_from_attribute_term" name="pa_from_attribute_term">
						<option></option>
					</select>
				</div>

				<div class="pa_form_section pa_to_category">
					<label for="pa_to_category"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('To Category', 'assemble'); ?></label>
					<select id="pa_to_category" name="pa_to_category">
						<option></option>
						<?php
						foreach( get_terms( 'product_cat', array( 'hide_empty' => false ) ) as $term )
							echo '<option value="'.esc_attr($term->term_id).'">'.esc_attr($term->name).'</option>';
						?>
					</select>
				</div>

				<div class="pa_form_section pa_to_attribute">
					<label for="pa_to_attribute"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('To Attribute', 'assemble'); ?></label>
					<select id="pa_to_attribute" name="pa_to_attribute">
						<option></option>
						<?php
						foreach( wc_get_attribute_taxonomies() as $term )
							echo '<option value="'.esc_attr($term->attribute_id).'">'.esc_html($term->attribute_label).'</option>';
						?>
					</select>
				</div>

				<div class="pa_form_section pa_to_attribute_term">
					<label for="pa_to_attribute_term"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('To Attribute Term', 'assemble'); ?></label>
					<select id="pa_to_attribute_term" name="pa_to_attribute_term">
						<option></option>
					</select>
				</div>

				<div class="pa_form_section pa_with_tag">
					<label for="pa_with_tag"><span class="pc_assemble_star">*</span> <?php echo esc_html_e('With Tag', 'assemble'); ?></label>
					<select id="pa_with_tag" name="pa_with_tag">
						<option></option>
						<?php
						foreach( get_terms( 'product_tag', array( 'hide_empty' => false ) ) as $term )
							echo '<option value="'.esc_attr($term->term_id).'">'.esc_html($term->name).'</option>';
						?>
					</select>
				</div>

				<div class="pa_form_section max">
					<input value="<?php echo esc_html_e('Save', 'assemble'); ?>" type="submit" name="pa_add_relation" />
				</div>

			</form>
		</div>
	</div>

</div>