<?php
$page = isset($_GET['tab']) ? sanitize_text_field( $_GET['tab'] ) : 'pa_general';
?>

<div id="pc_tabs_wrapper" class="<?php echo 'pa_'.esc_attr($page); ?>">
	<h3>
		<?php echo esc_html_e('All Sections', 'assemble'); ?>
		<button type="button" class="pa_add_section_btn"><?php echo esc_html_e('Add New Section', 'assemble'); ?></button>
	</h3>
	
	<table id="pa_sections" class="pa_section">
		<thead>
			<tr draggable="true">
				<th style="width: 18%"><?php echo esc_html_e('Title', 'assemble'); ?></th>
				<th style="width: 37%"><?php echo esc_html_e('Categories', 'assemble'); ?></th>
				<th style="width: 10%" class="text-center"><?php echo esc_html_e('Mandatory', 'assemble'); ?></th>
				<th style="width: 25%" class="text-center"><?php echo esc_html_e('Actions', 'assemble'); ?></th>
				<th style="width: 10%" class="text-center"><?php echo esc_html_e('Status', 'assemble'); ?></th>
			</tr>
		</thead>
		
		<tbody>
			<?php 
			foreach( $this->sections as $section ) 
			{
				echo '<tr class="ui-sortable-handle" data-id="'.esc_attr($section->id).'">';
					echo '<td class="pa_go_cat"><span class="dashicons dashicons-menu"></span>'.esc_html($section->name).'</td>';
					echo '<td class="section_categories">'.esc_html($section->categories).'</td>';
					$mandatory = $section->mandatory == 1 ? '<span class="dashicons dashicons-saved"></span>' : '<span class="dashicons dashicons-no-alt"></span>';
					echo '<td class="text-center">'.$mandatory.'</td>';
					echo '<td class="text-center">';
						echo '<a class="section_delete" href="admin.php?page=pa-settings&tab=sections&action=delete&id='.esc_attr($section->id).'"><span class="dashicons dashicons-trash"></span></a> &nbsp; <span class="dashicons dashicons-edit pa_edit_section_btn"></span> <button class="pa_go_categories" type="button">'.esc_html__("Categories", "assemble").'</button>';
						echo '<input type="hidden" class="id" value="'.esc_attr($section->id).'" />';
						echo '<input type="hidden" class="name" value="'.esc_attr($section->name).'" />';
						echo '<input type="hidden" class="mandatory" value="'.esc_attr($section->mandatory).'" /></td>';
					echo '<td class="text-center"><label class="switch">';?>
					<input class="pa_section_status" value="1" type="checkbox" data-id="<?php echo esc_attr($section->id); ?>" <?php checked($section->status, 1); ?>>
					<?php echo '<span class="slider round"></span></label></td>';
				echo '</tr>';
			}
			?>
		</tbody>
	</table>

	<div class="pa_tab_wrapper">
		<div class="pa_tab">
			<h2>
				<strong class="pa_add_section_title"><?php echo esc_html_e('Add section', 'assemble'); ?></strong>
				<strong class="pa_edit_section_title"><?php echo esc_html_e('Edit section', 'assemble'); ?></strong>
				<span class="pa_close_section_modal"><span class="dashicons dashicons-no-alt"></span>
			</h2>

			<form method="post" id="add_section_form">

				<input type="hidden" name="dlr_nonce" value="<?php echo esc_attr( wp_create_nonce('pa-nonce') ); ?>" />

				<div class="pa_form_section">
					<label><?php echo esc_html_e('Title', 'assemble'); ?></label>
					<input type="text" required autocomplete="odd" autofocus name="pa_section_title" />
					<input type="hidden" name="pa_section_id" />
				</div>

				<div class="pa_form_section">
					<label for="pa_section_mandatory"><?php echo esc_html_e('Mandatory', 'assemble'); ?></label>
					<select id="pa_section_mandatory" name="pa_section_mandatory">
						<option value="0"><?php echo esc_html_e('No', 'assemble'); ?></option>
						<option value="1"><?php echo esc_html_e('Yes', 'assemble'); ?></option>
					</select>
				</div>

				<div class="pa_form_section">
					<input value="<?php echo esc_html_e('Save', 'assemble'); ?>" type="submit" name="pa_add_section" />
				</div>

			</form>
		</div>
	</div>

</div>
</div>