document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.copy-btn').forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            e.stopPropagation();

            var code = this.getAttribute('data-code');
            navigator.clipboard.writeText(code).then(() => {
                alert('کد "' + code + '" با موفقیت کپی شد.');
            }).catch(() => {
                alert('مشکلی در کپی کردن کد به‌وجود آمد.');
            });
        });
    });
});
