jQuery(document).ready(function($){
    // تغییر وضعیت سفارش
    $(".save-status-btn").on("click", function(){
        let id = $(this).data("id");
        let status = $("#order-row-"+id+" .order-status").val();
        let msgBox = $("#status-msg-"+id);

        msgBox.html("در حال ذخیره...");
        $.post(wcOrderManager.ajax_url, {
            action: "wc_update_order_status",
            nonce: wcOrderManager.nonce,
            order_id: id,
            status: status
        }, function(response){
            if(response.success){
                msgBox.html("<span style='color:green'>"+response.data+"</span>");
            } else {
                msgBox.html("<span style='color:red'>"+response.data+"</span>");
            }
        });
    });

    // افزودن یادداشت
    $(".add-note-btn").on("click", function(){
        let id = $(this).data("id");
        let note = $("#order-row-"+id+" .new-note").val();
        let msgBox = $("#note-msg-"+id);

        if(!note){
            msgBox.html("<span style='color:red'>لطفاً یادداشت را وارد کنید.</span>");
            return;
        }

        msgBox.html("در حال ذخیره...");
        $.post(wcOrderManager.ajax_url, {
            action: "wc_add_order_note",
            nonce: wcOrderManager.nonce,
            order_id: id,
            note: note
        }, function(response){
            if(response.success){
                $("#notes-"+id).append("<div>- "+note+"</div>");
                $("#order-row-"+id+" .new-note").val("");
                msgBox.html("<span style='color:green'>"+response.data+"</span>");
            } else {
                msgBox.html("<span style='color:red'>"+response.data+"</span>");
            }
        });
    });
});
