<?php


if ( ! defined( 'ABSPATH' ) ) exit;


add_action('admin_menu', function() {
    add_submenu_page(
        'edit.php?post_type=product',
        'مخفی‌سازی محصولات ناموجود',
        'مخفی‌سازی ناموجودها',
        'manage_woocommerce',
        'jb-wc-hide-outofstock-category',
        'jb_wc_hide_outofstock_category_page'
    );
});


add_action('admin_enqueue_scripts', function($hook) {
    if ($hook !== 'product_page_jb-wc-hide-outofstock-category') return;

    wp_enqueue_style('select2-css', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');
    wp_enqueue_script('select2-js', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', ['jquery'], null, true);

    wp_add_inline_script('select2-js', "
        jQuery(document).ready(function($) {
            $('#jb_wc_hidden_cats').select2({
                placeholder: 'انتخاب دسته‌ها...',
                allowClear: true,
                width: '100%'
            });
        });
    ");
});


if ( ! function_exists( 'jb_wc_hide_outofstock_category_page' ) ) {
    function jb_wc_hide_outofstock_category_page() {
        if ( isset($_POST['jb_wc_hidden_cats_nonce']) && wp_verify_nonce($_POST['jb_wc_hidden_cats_nonce'], 'jb_wc_save_hidden_cats') ) {
            $selected_cats = isset($_POST['jb_wc_hidden_cats']) ? array_map('intval', $_POST['jb_wc_hidden_cats']) : [];
            update_option('jb_wc_hidden_outofstock_cats', $selected_cats);
            echo '<div class="updated"><p>تنظیمات ذخیره شد.</p></div>';
        }

        $saved_cats = get_option('jb_wc_hidden_outofstock_cats', []);

        echo '<div class="wrap"><h1>مخفی‌سازی محصولات ناموجود بر اساس دسته</h1>';
        echo '<form method="post">';
        wp_nonce_field('jb_wc_save_hidden_cats', 'jb_wc_hidden_cats_nonce');

        $cats = get_terms([
            'taxonomy'   => 'product_cat',
            'hide_empty' => false,
            'parent'     => 0
        ]);

        echo '<p>دسته‌ها و زیردسته‌هایی که می‌خواید <b>فقط محصولات ناموجود</b> اون‌ها مخفی بشه انتخاب کنید:</p>';
        echo '<select id="jb_wc_hidden_cats" name="jb_wc_hidden_cats[]" multiple="multiple" style="width:400px;">';
        jb_wc_render_select_options($cats, $saved_cats);
        echo '</select>';

        if ( !empty($saved_cats) ) {
            echo '<h3>✅ دسته‌های انتخاب‌شده:</h3><div style="margin:10px 0; padding:10px; background:#fff; border:1px solid #ddd; border-radius:6px;">';
            foreach ($saved_cats as $cat_id) {
                $term = get_term($cat_id, 'product_cat');
                if ($term && !is_wp_error($term)) {
                    echo '<span style="display:inline-block; background:#f1f1f1; padding:5px 10px; margin:3px; border-radius:4px;">'.$term->name.'</span>';
                }
            }
            echo '</div>';
        }

        submit_button();
        echo '</form></div>';
    }
}


if ( ! function_exists( 'jb_wc_render_select_options' ) ) {
    function jb_wc_render_select_options($terms, $saved_cats, $level = 0) {
        foreach ( $terms as $term ) {
            $selected = in_array($term->term_id, $saved_cats) ? 'selected' : '';
            $indent   = str_repeat('— ', $level);
            echo '<option value="'.esc_attr($term->term_id).'" '.$selected.'>'.$indent.$term->name.'</option>';

            $child_terms = get_terms([
                'taxonomy'   => 'product_cat',
                'hide_empty' => false,
                'parent'     => $term->term_id
            ]);
            if ( $child_terms ) {
                jb_wc_render_select_options($child_terms, $saved_cats, $level+1);
            }
        }
    }
}


add_filter('posts_where', function ($where, $query) {
    global $wpdb;

    if (is_admin() || ! $query->is_main_query()) {
        return $where;
    }

    if (
        ! $query->is_post_type_archive('product') &&
        ! $query->is_tax('product_cat') &&
        ! $query->is_search()
    ) {
        return $where;
    }

    $hidden_cats = get_option('jb_wc_hidden_outofstock_cats', []);
    if (empty($hidden_cats)) {
        return $where;
    }

    $cat_ids = implode(',', array_map('intval', $hidden_cats));


    $where .= "
        AND {$wpdb->posts}.ID NOT IN (
            SELECT p.ID
            FROM {$wpdb->posts} p
            INNER JOIN {$wpdb->postmeta} pm
                ON p.ID = pm.post_id
                AND pm.meta_key = '_stock_status'
                AND pm.meta_value = 'outofstock'
            INNER JOIN {$wpdb->term_relationships} tr
                ON p.ID = tr.object_id
            INNER JOIN {$wpdb->term_taxonomy} tt
                ON tr.term_taxonomy_id = tt.term_taxonomy_id
            WHERE tt.taxonomy = 'product_cat'
            AND tt.term_id IN ($cat_ids)
        )
    ";

    return $where;
}, 10, 2);
add_filter('woocommerce_product_is_visible', function ($visible, $product_id) {

    $hidden_cats = get_option('jb_wc_hidden_outofstock_cats', []);
    if (empty($hidden_cats)) {
        return $visible;
    }

    $product = wc_get_product($product_id);
    if (! $product) {
        return $visible;
    }

    if ($product->is_in_stock()) {
        return $visible;
    }

    if (has_term($hidden_cats, 'product_cat', $product_id)) {
        return false;
    }

    return $visible;

}, 10, 2);

add_filter(
    'woocommerce_get_filtered_term_product_counts_query',
    function ($query) {

        $hidden_cats = get_option('jb_wc_hidden_outofstock_cats', []);
        if (empty($hidden_cats)) {
            return $query;
        }

        if (!is_product_category() && !is_shop() && !is_search()) {
            return $query;
        }

        $current_cat = get_queried_object_id();

        if (!in_array($current_cat, $hidden_cats)) {
            return $query;
        }

        global $wpdb;

        $query['where'] .= "
            AND {$wpdb->posts}.ID NOT IN (
                SELECT post_id
                FROM {$wpdb->postmeta}
                WHERE meta_key = '_stock_status'
                AND meta_value = 'outofstock'
            )
        ";

        return $query;
    }
);
