<?php if (!defined('ABSPATH')) exit; ?>

<div class="wrap">
    <h1>مدیریت سفارشات</h1>

    <table class="widefat fixed striped" style="table-layout:fixed;">
        <thead>
            <tr>
                <th>شماره سفارش</th>
                <th>نام مشتری</th>
                <th>موبایل</th>
                <th>آدرس</th>
                <th>روش ارسال</th>
                <th>روش پرداخت</th>
                <th>ارسال پیامک</th>
                <th>توضیحات تکمیلی</th>
                <th>یادداشت‌ها</th>
                <th>وضعیت</th>
            </tr>
        </thead>
        <tbody>
        <?php if($orders && is_array($orders)) : ?>
            <?php foreach($orders as $order) : 
                $order_id = $order->get_id();
                $order_number = $order->get_order_number();
                $customer = esc_html($order->get_formatted_billing_full_name() ?: ('کاربر #' . $order->get_customer_id()));
                $phone = esc_html($order->get_billing_phone() ?: '—');
                $address_raw = $order->get_formatted_billing_address();
                $address = $address_raw ? esc_html(trim(preg_replace('/\s+/', ' ', str_replace(["<br/>","<br />","<br>"], " - ", $address_raw)))) : '—';
                $shipping = $order->get_shipping_methods();
                $shipping_text = !empty($shipping) ? implode(', ', wp_list_pluck($shipping,'name')) : '—';
                $payment_method = $order->get_payment_method_title() ?: '—';
            ?>
            <tr id="jb-order-row-<?php echo $order_id; ?>">
                <td>#<?php echo $order_number; ?></td>
                <td><?php echo $customer; ?></td>
                <td><?php echo $phone; ?></td>
                <td><?php echo $address; ?></td>
                <td><?php echo $shipping_text; ?></td>
                <td><?php echo $payment_method; ?></td>
                <td>
                    <button class="button jb-toggle-pwoosms" data-order="<?php echo $order_id; ?>">ارسال پیامک</button>
                    <div id="pwoosms_box_<?php echo $order_id; ?>" class="jb-pwoosms-box" style="display:none;">
                        <textarea id="pwoosms_message_<?php echo $order_id; ?>" class="widefat" rows="3"></textarea>
                        <button class="button jb-pwoosms-submit" data-order="<?php echo $order_id; ?>">ارسال</button>
                    </div>
                </td>
                <td><?php echo esc_html($order->get_customer_note() ?: '—'); ?></td>
                <td>
                    <div class="jb-order-notes" style="max-height:80px; overflow:auto; padding:6px; border:1px solid #eee;">
                        <?php 
                        $notes = wc_get_order_notes(['order_id'=>$order_id]);
                        foreach($notes as $note) {
                            echo '<div>- ' . esc_html(trim(preg_replace('/\s+/', ' ', wp_strip_all_tags($note->content)))) . '</div>';
                        }
                        ?>
                    </div>
                    <textarea id="jb_note_input_<?php echo $order_id; ?>" rows="2" class="widefat" placeholder="یادداشت جدید..."></textarea>
                    <button class="button jb-add-note" data-order="<?php echo $order_id; ?>">افزودن یادداشت</button>
                </td>
                <td>
                    <select class="jb-order-status" data-id="<?php echo $order_id; ?>">
                        <?php foreach(wc_get_order_statuses() as $key => $label) : ?>
                            <option value="<?php echo esc_attr($key); ?>" <?php selected('wc-'.$order->get_status(), $key); ?>><?php echo esc_html($label); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <button class="button jb-save-status" data-order="<?php echo $order_id; ?>">ذخیره</button>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="10">هیچ سفارشی یافت نشد.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>

    <?php if($total_pages > 1): ?>
        <div class="tablenav">
            <div class="tablenav-pages">
                <?php
                    $base = add_query_arg('paged','%#%');
                    echo paginate_links([
                        'base' => $base,
                        'format' => '',
                        'prev_text' => '« قبلی',
                        'next_text' => 'بعدی »',
                        'total' => $total_pages,
                        'current' => $paged,
                    ]);
                ?>
            </div>
        </div>
    <?php endif; ?>
</div>
