<?php

namespace Zhaket\SmartHub;


use Zhaket\SmartHub\Admin\Ajax;
use Zhaket\SmartHub\Hub\Hub;
use Zhaket\SmartHub\Update\CheckUpdate;

class Main
{
    protected static $_instance = null;
    public static $option=false;

    public static function getInstance()
    {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct()
    {
        $this->global();
        $this->adminMenu();
            CheckUpdate::getInstance();
        if (defined('DOING_AJAX') && DOING_AJAX) {
            Ajax::getInstance();
        }
        if (
            (!defined('WP_SANDBOX_SCRAPING') || (defined('WP_SANDBOX_SCRAPING') && !WP_SANDBOX_SCRAPING)) &&
            get_option('zhaket_smart_hub_upgrade', false) !=='on' &&
            (
                self::getOption('reject')=='on' ||
                self::getOption('proxy')=='on' ||
                self::getOption('log_request')=='on'
            )
        ){
            Hub::get_instance();
        }
    }

    public function global()
    {
        add_filter( 'plugin_action_links_zhaket-smart-hub/smart-hub.php', array($this, 'filterActionLinks'), 10, 1 );
        add_action( 'activated_plugin', array($this, 'pluginActivated'), 10, 1 );
        add_action('wp_dashboard_setup',function (){
            wp_add_dashboard_widget('zhaket_smart_hub_widget', esc_html__('zhaket smart hub','zhaket-smart-hub'), [$this,'widgetCallback'],null,null,'normal','high');
        });

    }


    public function filterActionLinks($links)
    {
        $links[ 'support' ] = sprintf(
            "<a href='%s' id='zhaket-smart-hub-settings'>%s</a>",
            admin_url( '/admin.php?page=zhaket-smart-hub' ),
            __( 'Settings', 'zhaket-smart-hub' )
        );
        return $links;
    }

    public function pluginActivated($plugin)
    {
        if ( $plugin === 'zhaket-smart-hub/smart-hub.php' ) {
            exit( wp_redirect( self_admin_url( 'admin.php?page=zhaket-smart-hub') ) );
        }
    }

    public function adminMenu()
    {
        add_action( 'admin_menu', array(\Zhaket\SmartHub\Admin\AdminMenu::getInstance(), 'adminMenu') );
        add_action( 'admin_enqueue_scripts', array(\Zhaket\SmartHub\Admin\AdminMenu::getInstance(), 'enqueueScripts') );
    }

    public static function setOption($type,$value)
    {
        if(self::$option===false){
            self::$option=get_option('zhaket_smart_hub',[]);
        }

        switch ($type){
            case 'reject':
                self::$option['reject']=(($value=='on')?'on':'off');
                break;
            case 'proxy':
                self::$option['proxy']=(($value=='on')?'on':'off');
                break;
            case 'log_request':
                self::$option['log_request']=(($value=='on')?'on':'off');
                break;
            case 'save_type':
                self::$option['save_type']=(($value=='file')?'file':'database');
                break;
        }
        update_option( 'zhaket_smart_hub', self::$option );
    }

    public static function getOption($type)
    {
        if(self::$option===false){
            self::$option=get_option('zhaket_smart_hub',[]);
        }
        $option=self::$option;
        switch ($type){
            case 'reject':
                return isset($option['reject'])?$option['reject']:'off';
            case 'proxy':
                return isset($option['proxy'])?$option['proxy']:'off';
            case 'log_request':
                return isset($option['log_request'])?$option['log_request']:'off';
            case 'save_type':
                return isset($option['save_type'])?$option['save_type']:'file';
        }
    }
    public function widgetCallback(){
        wp_print_styles('smr_dashboard_style');
        $status=self::getOption('proxy')=='on'?'on':'off';
        $need_update=get_option('zhaket_smart_hub_upgrade', false) ==='on';
        $error=get_transient('zhaket_smart_hub_proxy_error');
        if (!empty($error)){
            $status='<span style="color: red">'.__('error','zhaket-smart-hub').' <br>'.__($error,'zhaket-smart-hub').'</span>';
        }
        if ($need_update){
            $status='<span style="color: red">'.__('need update','zhaket-smart-hub').'</span>';
        }
        switch ($status){
            case 'on':
                $status_image='<span style="color: green">ON</span>';
                $status=__('on','zhaket-smart-hub');
                break;
            case 'off':
                $status_image='<span style="color: red">OFF</span>';
                $status=__('off','zhaket-smart-hub');
                break;
            default:
                $status_image='<span style="color: orange;font-size: 25px">!</span>';
                break;
        }

        require_once ZHAKET_SMART_HUB_DIR.'/templates/widget.php';
    }

    protected function translate_server_error(){
            __("Invalid data send","zhaket-smart-hub");
            __("Domain is not valid","zhaket-smart-hub");
            __("Your server time is not valid","zhaket-smart-hub");
            __("Key is not valid","zhaket-smart-hub");
            __("Your domain is in drop list","zhaket-smart-hub");
            __("Empty response","zhaket-smart-hub");
            __("File Key not found","zhaket-smart-hub");
            __("Connection timed out","zhaket-smart-hub");
            __("SmartHub Connection timed out","zhaket-smart-hub");
            __("Your website reject access to key file","zhaket-smart-hub");
            __("cURL error 35 (OpenSSL SSL_connect)","zhaket-smart-hub");
            __("Your domain ip cannot resolved","zhaket-smart-hub");
            __("SmartHub ip cannot resolved","zhaket-smart-hub");
            __("Too many redirect on check key file","zhaket-smart-hub");
            __("Domain Key is not valid","zhaket-smart-hub");
    }

    public static function smartHubNoticeGuide($message)
    {
        $link='';
        if (strlen($message)<50){
            $link=sprintf(" (<a href='%s'>%s</a>)", admin_url( '/admin.php?page=zhaket-smart-hub-problem-guide#'.str_replace(' ','',strtolower($message))),esc_html__('View Guide','zhaket-smart-hub'));
        }
        return __($message,'zhaket-smart-hub').$link;
    }
}