<?php
  
  
class WACM_Admin_Ajax {
		    
	function __construct() {
		
		add_action( 'wp_ajax_wacm_admin', array( $this,  'admin_ajax_callback' ) );
		// add_action( 'wp_ajax_nopriv_wacm_admin', 'admin_ajax_callback' );
    } 
	  
	function admin_ajax_callback(){
		
		global $wpdb,$wp_taxonomies;
 
		ob_start();
		
		$inputJSON 	= file_get_contents('php://input');
		$getInput	= json_decode($inputJSON, TRUE);
		
		// check_ajax_referer( 'wacm-admin-ajax', 'security' );
		
		if ( ! current_user_can( 'edit_products' ) ) {
			wp_die( -1 );
		}
		
		$get_page		= $getInput['wacm_page'] 	?? '';
		$get_action		= $getInput['wacm_action'] 	?? '';
		$get_form		= $getInput['form'] 		?? '';
	 							
		$get_form		= isset($get_form[0])		? $get_form : array( "0" => $get_form );
		 
		if ( empty($get_page) || empty($get_action) ) {
			
			wp_send_json_error( array(
				'all' => __( 'Requset 404', 'wacm' )
			));
		} 
	 
		switch ($get_page) {
			
			case "attribute":
		 
				self::attribute_( $get_action , $get_form );
				break;
				 
			case "default":
			 
				self::default_( $get_action , $get_form );
				break;
				 	 
			case "product":
		 
				self::product_( $get_action , $get_form );
				break;
				 
			case "bulk":
		 
				self::bulk_( $get_action , $get_form );
				break;	 
				
			case "tools":
		 
				self::tools_( $get_action , $get_form );
				break;	 
				
			case "treedummy":
		 
				self::treedummy_();
				break;
				  
			case "dummy":
		 
				self::dummy_();
				break;
				
		}
 
		wp_send_json_success('NotPage');
	} 

	function product_( $act , $data_array ){
		
		global $wpdb,$wp_taxonomies;
		
		if( 'list' == $act ){
			
			$massage = self::list_products_callback();
		}else{
			
			foreach( $data_array as $data_key => $data ){
						
				$product_id			= $data['product_id'] 			?? 0;
  				$product_attributes	= $data['product_attributes']	?? [];
				
  				if( 'save_attribute' == $act ){
					
					$product_attributes_ = self::____get_post_attributs( $product_id , $product_attributes , 'product');
					
					update_post_meta( intval($product_id), '_product_attributes', $product_attributes_ );
					
					$massage[$data_key] = self::list_products_callback($product_id);
				}
			}
			
			WACM_Admin__update_all_count_taxonomy();
		}
		
		wp_send_json_success($massage);
	}
 
	function list_products_callback( $product_id_ = -1 ){
	
		global $wpdb;
		
		if( -1 == $product_id_ ){
			
			$products_ = $wpdb->get_results("SELECT {$wpdb->posts}.ID,{$wpdb->posts}.post_title
								 FROM {$wpdb->posts} WHERE post_type = 'product' and post_status NOT IN ('auto-draft','trash')");	        
		}else{
			 
			$products_ = $wpdb->get_results( "SELECT {$wpdb->posts}.ID,{$wpdb->posts}.post_title
													FROM {$wpdb->posts} WHERE ID = {$product_id_}" );
		}
		 
		$rows_ = [];
		foreach($products_ as $value){
			
			$product_id	= $value->ID;	
			  
			$product_attrib_ = get_post_meta($product_id,'_product_attributes',true);
			 
			$result = self::___attributes_callback($product_id , $product_attrib_, 'product');
			
			$rows_[$product_id]['product_attributes']	= $result;
 			$rows_[$product_id]["product_id"]			= $product_id;
			$rows_[$product_id]["product_name"]			= $value->post_title;
		}
		 
		if( -1 != $product_id_ ){
		
			return $rows_[$product_id_];
		}
		
		return $rows_;
	}
	 
	function default_( $act , $data_array ){
		
		global $wpdb,$wp_taxonomies;

		$massage = [];
		
		if( 'list' == $act ){
			
			$massage = self::get_defaults_callback();
		}elseif( 'old_list' == $act ){
			
			self::old_list_defaults_callback();
		}else{
			
			foreach( $data_array as $data_key => $data ){
						
				$default_id			= $data['default_id'] 				?? 0;
 				$default_name		= $data['default_name']				?? '';
 				$default_is_dokan	= isset($data['default_is_dokan'])	? 1 : 0;
 				$default_attributes	= $data['default_attributes']		?? [];
 
				if( 'delete' == $act ){
					 
					wp_delete_post( (int) $default_id, true );
					$massage[$data_key] = $default_id;
					
				}elseif( 'create' == $act ){
					
					$setting['is_dokan'] = $default_is_dokan;
					
					$my_post['post_title'] 		= wp_strip_all_tags( $default_name );
 					$my_post['post_excerpt'] 	= serialize($setting);
					$my_post['post_status'] 	= 'publish';
					$my_post['post_author'] 	= get_current_user_id();
					$my_post['post_type'] 		= WACM_POST_TYPE_DEFAULT;
			 
					if( !$default_id ){
						
						$default_id = wp_insert_post($my_post);	
					}else{
						
						$my_post['ID'] = $default_id;
						wp_update_post( $my_post );
					}
					 
					$massage[$data_key] = self::get_defaults_callback($default_id);
					
				}elseif( 'save_attribute' == $act ){
					
 					$default_attributes_ = self::____get_post_attributs($default_id , $default_attributes , 'defaulte');
					 
					$my_post['post_content']	= serialize($default_attributes_);
					$my_post['ID'] 				= $default_id;
					wp_update_post( $my_post );
					  
					$massage[$data_key] = self::get_defaults_callback($default_id);
				}
				
			}
		}
		
		wp_send_json_success($massage);
	}
 
	function get_defaults_callback( $default_id_ = -1 ){
	
		global $wpdb;
		 
		if( -1 == $default_id_ ){
			
			$defaults_ = $wpdb->get_results("SELECT {$wpdb->posts}.ID,{$wpdb->posts}.post_title,{$wpdb->posts}.post_content,{$wpdb->posts}.post_excerpt
													FROM {$wpdb->posts} WHERE post_type = 'wacm_default'");	        
		}else{
			 
			$defaults_ = $wpdb->get_results( "SELECT {$wpdb->posts}.ID,{$wpdb->posts}.post_title,{$wpdb->posts}.post_content,{$wpdb->posts}.post_excerpt
													FROM {$wpdb->posts} WHERE ID = {$default_id_}" );
		}
		
		$rows_ = [];
		foreach($defaults_ as $value){
			
			$default_id 			= $value->ID;	
			$defaultes_attributes_ 	= unserialize( $value->post_content );
			$defaultes_setting 		= unserialize( $value->post_excerpt );
			 
			$default_is_dokan 		= $defaultes_setting['is_dokan'] ?? 0;
			
			$result = self::___attributes_callback( $default_id , $defaultes_attributes_ , 'defaulte' );
			 
			$rows_[$default_id]['defaulte_attributes']	= $result;
 			$rows_[$default_id]["default_id"]			= $default_id;
			$rows_[$default_id]["default_name"]			= $value->post_title;
			$rows_[$default_id]["default_is_dokan"]		= $default_is_dokan;
		}
		
		
		if( -1 != $default_id_ ){
		
			return $rows_[$default_id_];
		}
		
		return $rows_;
	}
	 
	function attribute_( $act , $data_array ){
		
		global $wpdb,$wp_taxonomies;
		
		if( 'list' == $act ){
			
			$massage = self::get_attributes_callback();
		}else{
			 
			foreach( $data_array as $data_key => $data ){
						
				$attribute_id		= (int) 	($data['attribute_id'] 			?? 0);
				$attribute_label	= (string) 	($data['attribute_label'] 		?? '');
				$attribute_name		= (string) 	($data['attribute_name'] 		?? $attribute_label);
				$attribute_orderby	= (string) 	($data['attribute_orderby']		?? 'menu_order');
				$attribute_public	= (int) 	($data['attribute_public'] 		?? 0);
				$attribute_values	= (array) 	($data['attribute_values'] 		?? []);
					 
				$attribute_name 	= wc_sanitize_taxonomy_name( substr( $attribute_name, 0, 27 ) );
			 
				$old_slug = '';
				
				if( 'delete' == $act ){
					
					wc_delete_attribute( (int) $attribute_id );
					$massage[$data_key] = $attribute_id;
					
				}elseif( 'create' == $act ){
					
					if($attribute_id){
					
						$old_slug = $wpdb->get_var(
							$wpdb->prepare(
								"
									SELECT attribute_name
									FROM {$wpdb->prefix}woocommerce_attribute_taxonomies
									WHERE attribute_id = %d
								",
								$attribute_id
							)
						);
					}
					
					if( empty($attribute_label) ){
						
						wp_send_json_error( array(
							'attribute_label' => __( 'Require', 'wacm' )
						));				
					}elseif ( strlen( $attribute_name ) >= 28 ) {
						
						wp_send_json_error( array(
							'attribute_name' => sprintf( __( 'Slug "%s" is too long (28 characters max). Shorten it, please.', 'woocommerce' ), $attribute_name )
						));
					} elseif ( wc_check_if_attribute_name_is_reserved( $attribute_name ) ) {			
					
						wp_send_json_error( array(
							'attribute_name' => sprintf( __( 'Slug "%s" is not allowed because it is a reserved term. Change it, please.', 'woocommerce' ), $attribute_name )
						));
					} elseif ( ( $old_slug != $attribute_name ) && taxonomy_exists( wc_attribute_taxonomy_name( $attribute_name ) ) ) {
						
						wp_send_json_error( array(
							'attribute_name' => sprintf( __( 'Slug "%s" is already in use. Change it, please.', 'woocommerce' ), $old_slug )
						));
					}
					   
					$args	= array(
						'id'			=> $attribute_id,
						'name'			=> $attribute_label,
						'slug'			=> $attribute_name,
						'type'			=> 'select',
						'order_by'		=> $attribute_orderby,
						'has_archives'	=> $attribute_public ?? 0,
					);						
					$attribute_id 	=  wc_create_attribute( $args );
				
					$taxonomy = wc_attribute_taxonomy_name($attribute_name);
					 
					if(!$attribute_id) $wp_taxonomies[$taxonomy] = (object) (['hierarchical'=>'']);
					
					
					self::save_attribute_values_callback($attribute_values,$taxonomy,'attribute');
					
					$massage[$data_key] = self::get_attributes_callback($attribute_id);
				}
				
			}
		}
		
		wp_send_json_success($massage);
	}
 
	function get_attributes_callback( $attribute_id_ = -1 ){
	
		global $wpdb;
		
		if( -1 == $attribute_id_){
			
			$taxonomies	= wc_get_attribute_taxonomies();	        
		}else{
			
			$taxonomies = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}woocommerce_attribute_taxonomies 
										 WHERE attribute_id = {$attribute_id_} ORDER BY attribute_name ASC;" );
		}
		  
		$tax_ = [];
		foreach ( $taxonomies as $key => $taxonomy ) {
			
			$attribute_id	= $taxonomy->attribute_id;			
			$attribute_name	= $taxonomy->attribute_name;
			
			$tax_[$attribute_id] = (array) $taxonomy;
			 
			$attribute_values = get_terms( array(
				'taxonomy' => wc_attribute_taxonomy_name( $attribute_name ),
				'hide_empty' => false,
			)); 
			 
			$tax_[$attribute_id]['attribute_values'] = $attribute_values;			
		}
		
		if( -1 != $attribute_id_ ){
		
			return $tax_[$attribute_id];
		}
		
		return $tax_;
	}
	 
	function save_attribute_values_callback( $attribute_values = [] , $taxonomy = '', $type = 'product' ){
	
		global $wpdb, $wp_taxonomies;
		  
		$wp_taxonomies[$taxonomy] = (object) (['hierarchical'=>'']);
		
		$terms = get_terms( $taxonomy, array( 'fields' => 'ids', 'hide_empty' => false ) );
		
		$value_ids = [];
		
		if(!empty($attribute_values)){
			
			foreach($attribute_values as $vv){
 
				if( isset($vv["code"]) && isset($vv["name"]) ){
					
					$code = $vv["code"];
					$name = $vv["name"];	
				}else{
					
					$code = 0;
					$name = $vv;
				}
				 
				$vr = get_term_by('name', $name, $taxonomy);
				if($vr){
					
					$code = $vr->term_id;
				}else{
						
					$term = wp_insert_term(
						$name,
						$taxonomy,
						array( 'parent' => 0 )
					);
					
					if (is_wp_error($term)) {
						 
						wp_send_json_success('errorInsertTerm');
					}

					$code = $term['term_id'];
				}
				
				if (($key = array_search($code, $terms)) !== false) {
					unset($terms[$key]);
				}
	 
				$value_ids[] = $code;
				
				if( 'product' == $type ){
					
					$r = wp_set_object_terms(intval($id_), intval($code), $slug,true);	
				}
			}
		}
		
		if( 'attribute' == $type ){
			
			foreach ( $terms as $value ) {
				
				wp_delete_term( $value, $taxonomy );
			}
		}				
			
	}
	 
	function ____get_post_attributs( $id_ , $attributes , $type = 'product' ){
	 
		global $wpdb, $wp_taxonomies;
		
		$new_ 		= [];
		$position   = 0;
		
		if(!empty($attributes)){
			
			foreach($attributes as $attribute){
				
				$insert_check = 1;
				
				$attribute_name			= $attribute["attribute_name"]		?? '';
				$attribute_slug			= $attribute["attribute_slug"]		?? $attribute_name;
				$attribute_visible		= $attribute["attribute_visible"]	? 1 : 0;
				$attribute_variation	= $attribute["attribute_variation"] ? 1 : 0;
				$attribute_values		= $attribute["attribute_values"] 	?? [];
				
				if( empty($attribute_name) ){
					continue;
				}
					
				if( isset($attribute["custom_"]) && $attribute["custom_"] ){
					
					$values = [];
					foreach($attribute_values as $vv){
						
						$code = $vv["code"];
						$name = $vv["name"];
						
						$values[] = $name;
					}
					 
					$attribute_name =  $attribute_name;
					$slug_ 			=  sanitize_title( $attribute_name);
				 
					$new_[$slug_]["name"]			= $attribute_name;
					$new_[$slug_]["value"]			= ($type=='product') ? implode('|',$values) : $values;
					$new_[$slug_]["position"] 		= $position++;
					$new_[$slug_]["is_visible"]		= $attribute_visible;
					$new_[$slug_]["is_variation"]	= $attribute_variation;
					$new_[$slug_]["is_taxonomy"]	= 0;
					  
					continue;
				}
				
				if( isset($attribute["new_"]) && $attribute["new_"] ){
					
					$attribute_name = $attribute_name;
					$attribute_slug = wc_sanitize_taxonomy_name(  substr( $attribute_slug , 0, 27) );

					$id_select = wc_attribute_taxonomy_id_by_name( $attribute_slug ); 
				 
					if ( !$id_select ){
						 
						if( empty($attribute_name) ){
							
							continue;			
						}elseif ( strlen( $attribute_slug ) >= 28 ) {
							
							continue;
						} elseif ( wc_check_if_attribute_name_is_reserved( $attribute_slug ) ) {			

							continue;
						} elseif ( taxonomy_exists( wc_attribute_taxonomy_name( $attribute_slug ) ) ) {
							
							continue;
						}
						
						$args	= array(
							'name'		=> $attribute_name,
							'slug'		=> $attribute_slug,
							'type'		=> 'select',
							'order_by'	=> 'menu_order',
							'visible'	=> $attribute_visible,
						);						
						$id_select 	=  wc_create_attribute( $args );
						$insert_check = 1;  
					} 
					
				}else{
					
					$id_select 		= (int) $attribute["attribute_name"];
				}
				 
				if( !$id_select ) continue; 

				$tt 	= "{$wpdb->prefix}woocommerce_attribute_taxonomies";
				$result = (array) $wpdb->get_row( "SELECT attribute_name,attribute_label FROM {$tt} WHERE attribute_id = '{$id_select}'");
				$slug	= 'pa_' . $result['attribute_name'];
				$name 	= $result['attribute_label']; 			 
				 
				if($insert_check) $wp_taxonomies[$slug] = (object) (['hierarchical'=>'']);
				
				wp_delete_object_term_relationships( intval($id_), $slug );
			
				$attribute_values = isset($attribute_values[0]) ? $attribute_values : ["0" => $attribute_values];
	 
				$value_ids = [];
				
				if(!empty($attribute_values)){
						
					foreach($attribute_values as $vv){
						
						if(empty($vv["code"]) || empty($vv["name"])) continue;
						
						$code = $vv["code"];
						$name = $vv["name"];
						 
						if( substr($code,0,5) =='newid' ){
							
							$vr = get_term_by('name', $name, $slug);
							if($vr){
								
								$code = $vr->term_id;
							}else{
									
								$term = wp_insert_term(
									$name,
									$slug,
									array( 'parent' => 0 )
								);
			
								if (is_wp_error($term)) {
									 
									wp_send_json_success('errorInsertTerm');
								}

								$code = $term['term_id'];
							}
						
						}
						
						$value_ids[] = $code;
						
						if( 'product' == $type ){
							
							$r = wp_set_object_terms(intval($id_), intval($code), $slug,true);	
						}
						
					}
				}
				
				if( 'product' == $type ){
					 
					$new_[$slug]["value"] 	= '';
				}else{
					
					$new_[$slug]["value"]	= $value_ids;
				}
					
				$new_[$slug]["name"]			= $slug;
				$new_[$slug]["position"] 		= $position++;
				$new_[$slug]["is_visible"]		= $attribute_visible;
				$new_[$slug]["is_variation"]	= $attribute_variation;
				$new_[$slug]["is_taxonomy"]		= 1;
			}
		}
		
		return $new_;
	}
	
	function ___attributes_callback($id_ , $attributes_ , $type ='product' ){
		
		global $wpdb;
		
		$rows_ = [];
		
		if(!empty($attributes_)){
				
			foreach($attributes_ as $key => $atrrib){
			
				$slug_ = $atrrib['name'];
			
				if(substr($slug_,0,3)=='pa_'){
					
					$slug = substr($slug_,3); 
						
					$tt = "{$wpdb->prefix}woocommerce_attribute_taxonomies";
					$result = $wpdb->get_row( "SELECT * FROM {$tt} WHERE attribute_name = '{$slug}'");
					 
					if (is_wp_error($result)) {
							 
						wp_send_json_success('errorGetAtt');
					}
					
					if ( is_null( $result ) || empty( $result ) || ('undefined' == $result) ){
						  
						continue;
					}
					else{
						
						$attribute_id		= $result->attribute_id;						
						$attribute_label	= $result->attribute_label;						
					}
					
					$rows_[$key] 					= $atrrib;
					$rows_[$key]['attribute_id']   	= $attribute_id;
					$rows_[$key]['attribute_name']	= $attribute_label;
					
					
					if( 'product' == $type ){
						
						$values = wp_get_post_terms( $id_ , $slug_ );	
						$rows_[$key]['attribute_values']  = $values;
							
					}else{
						
						$value_ 	= [];
						$value_ids	= $atrrib['value'];
			
						foreach( $value_ids as $vv){
							$vr = get_term_by('id', $vv, 'pa_'.$slug);
							if($vr){
								$value_[$vv]  = $vr;
							}
						}
						$rows_[$key]['attribute_values']  = $value_;
					}
					  
				}else{
					
					$rows_[$key] 						= $atrrib;
					$rows_[$key]['attribute_name'] 		= $atrrib['name'];
					$rows_[$key]['attribute_values'] 	= ($type=='product') ? explode('|',$atrrib['value']) : $atrrib['value'];

					unset( $rows_[$key]['name'] );
					unset( $rows_[$key]['value'] );
				}
			}
		}
		
		return $rows_;
	}
	 
	function treedummy_(){
	
		$dir_ = WACM_ABSPATH . "/dummy-data/";
		$dir_file_ = $dir_ . '17-03-99-tree.json';
		
		if(is_file($dir_file_)){
			
			$get = file_get_contents($dir_file_);
			
			if(!empty($get)){
				
				$text_file = gzuncompress($get);
				
				if(!empty($text_file)){
					
					$tree_dummys = @json_decode($text_file, true);
					
					if(is_array($tree_dummys)){
		
						wp_send_json_success($tree_dummys);
					}
				}
			}
		}
		
		wp_send_json_success([]);		
	}

	function dummy_(){
	
		$dir_ = WACM_ABSPATH . "/dummy-data/";
			
		$list_ = glob( $dir_ . '17-03-99-*.json' );		
		
		$new = [];
		foreach( $list_ as $dir_file_ ){

			$file_name = str_replace( '17-03-99-', '', basename( $dir_file_ , ".json" ) );
			$content	= json_decode ( gzuncompress( file_get_contents( $dir_file_ ) ) , true );			 
			
			if(isset($content[$file_name]))
				$new[$file_name] = $content[$file_name];
		}
		
		wp_send_json_success($new);			  
	}
	
	function bulk_( $act , $data_array ){
	 
		global $wpdb,$wp_taxonomies;
		
		if( 'add_attribute_to_products' == $act ){
			
			$products 	= $data_array[0]['select_products'] ?? [];
			$attribute	= $data_array[0]['attribute'] 		?? [];
			
			if( empty($products) ){
				
				wp_send_json_success( 'No products' );		
			}
			
			if( empty($attribute) ){
				
				wp_send_json_success( 'No attribute' );		
			}
		
			$attribute_one	= self::__get_check_insert_atrribute( $attribute );
			
			foreach( $products as $product_id ){
				
				$product_attrib_ = get_post_meta($product_id,'_product_attributes',true);
				if( empty($product_attrib_) ) $product_attrib_ = [];
				
				foreach( $attribute_one as $key_a => $value_a ){
						 
					$product_attrib_[ sanitize_title($key_a) ] = array(
						'name'         => wc_clean($value_a['name']),
						'value'        => '',
						'position'     => count($product_attrib_),
						'is_visible'   => $value_a['is_visible']	?? 0,
						'is_variation' => $value_a['is_variation'] 	?? 0,
						'is_taxonomy'  => $value_a['is_taxonomy'] 	?? 0, 
					);   
				 
					if( $product_attrib_[$key_a]['is_taxonomy'] ){
						
						foreach( $value_a['value'] as $kv => $vv ){
							
							wp_set_object_terms(intval($product_id), intval($vv), $value_a['name'],true);
						}
					}else{
					
						$product_attrib_[$key_a]['value']	= implode( ' | ', $value_a['value'] );
					}
				}
				 
				update_post_meta( intval($product_id), '_product_attributes', $product_attrib_ );
			}
			 
			WACM_Admin__update_all_count_taxonomy();
			
			wp_send_json_success('ok');
		}
		
		wp_send_json_success('');		  
	}
	
	function tools_( $act , $data_array ){
		
		global $wpdb,$wp_taxonomies;
		
		if( 'update_show_filter' == $act ){
			
			WACM_Admin__update_all_count_taxonomy();
			
			wp_send_json_success('ok');
		}
		
		wp_send_json_success('');
	}
	
	function __get_check_insert_atrribute( $attribute , $type = '' ){
		
		global $wpdb,$wp_taxonomies;
		
		$insert_check 	= 1; 
		$position 		= 0;
		
		$attribute_name			= $attribute["attribute_name"]				?? '';
		$attribute_slug			= $attribute["attribute_slug"]				?? $attribute_name;
		$attribute_visible		= isset($attribute["attribute_visible"])	? 1 : 0;
		$attribute_variation	= isset($attribute["attribute_variation"])  ? 1 : 0;
		$attribute_values		= $attribute["attribute_values"] 			?? [];
		
		if( empty($attribute_name) || $attribute_name == -1 ){
			return;
		}
		
		if( isset($attribute["custom_"]) && $attribute["custom_"] ){
			
			$values = [];
			foreach($attribute_values as $vv){
				
				$code = $vv["code"];
				$name = $vv["name"];
				
				$values[] = $name;
			}
			 
			$attribute_name =  $attribute_name;
			$slug_ 			=  sanitize_title( $attribute_name);
		 
			$new_[$slug_]["name"]			= $attribute_name;
			$new_[$slug_]["value"]			= ($type=='product') ? implode('|',$values) : $values;
			$new_[$slug_]["position"] 		= $position++;
			$new_[$slug_]["is_visible"]		= $attribute_visible;
			$new_[$slug_]["is_variation"]	= $attribute_variation;
			$new_[$slug_]["is_taxonomy"]	= 0;
			  
			return $new_;
			
		}else if( isset($attribute["new_"]) && $attribute["new_"] ){
			
			$attribute_name = $attribute_name;
			$attribute_slug = wc_sanitize_taxonomy_name(  substr( $attribute_slug , 0, 27) );

			$id_select = wc_attribute_taxonomy_id_by_name( $attribute_slug ); 
		 
			if ( !$id_select ){
				 
				if( empty($attribute_name) ){
					
					return;			
				}elseif ( strlen( $attribute_slug ) >= 28 ) {
					
					return;
				} elseif ( wc_check_if_attribute_name_is_reserved( $attribute_slug ) ) {			

					return;
				} elseif ( taxonomy_exists( wc_attribute_taxonomy_name( $attribute_slug ) ) ) {
					
					return;
				}
				
				$args	= array(
					'name'		=> $attribute_name,
					'slug'		=> $attribute_slug,
					'type'		=> 'select',
					'order_by'	=> 'menu_order',
					'visible'	=> $attribute_visible,
				);						
				$id_select 	=  wc_create_attribute( $args );
				$insert_check = 1;  
			}
		}else{
			
			$id_select 		= (int) $attribute["attribute_name"];
		}
		 
		if( !$id_select ) return; 

		$tt 	= "{$wpdb->prefix}woocommerce_attribute_taxonomies";
		$result = (array) $wpdb->get_row( "SELECT attribute_name,attribute_label FROM {$tt} WHERE attribute_id = '{$id_select}'");
		$slug	= 'pa_' . $result['attribute_name'];
		$name 	= $result['attribute_label']; 			 
		
		if($insert_check) $wp_taxonomies[$slug] = (object) (['hierarchical'=>'']);
		
		// wp_delete_object_term_relationships( intval($id_), $slug );
	
		$attribute_values	= isset($attribute_values[0])	? $attribute_values : array( "0" => $attribute_values );

		$value_ids = [];
		foreach($attribute_values as $vv){
			
			$code = $vv["code"];
			$name = $vv["name"];
			 
			if( substr($code,0,5) =='newid' ){
				
				$vr = get_term_by('name', $name, $slug);
				if($vr){
					
					$code = $vr->term_id;
				}else{
						
					$term = wp_insert_term(
						$name,
						$slug,
						array( 'parent' => 0 )
					);

					if (is_wp_error($term)) {
						 
						wp_send_json_success('errorInsertTerm');
					}

					$code = $term['term_id'];
				}
			
			}
			
			$value_ids[] = $code;
			
			// if( 'product' == $type ){
				
				// $r = wp_set_object_terms(intval($id_), intval($code), $slug,true);	
			// }
			
		}

		if( 'product' == $type ){
			 
			$new_[$slug]["value"] 	= '';
		}else{
			
			$new_[$slug]["value"]	= $value_ids;
		}
			
		$new_[$slug]["name"]			= $slug;
		$new_[$slug]["position"] 		= $position++;
		$new_[$slug]["is_visible"]		= $attribute_visible;
		$new_[$slug]["is_variation"]	= $attribute_variation;
		$new_[$slug]["is_taxonomy"]		= 1;
		
		return $new_;
	}
	
	function old_list_defaults_callback(){
	
		global $wpdb;
		 
		$defaults_ = $wpdb->get_results("SELECT {$wpdb->posts}.ID,{$wpdb->posts}.post_title,{$wpdb->posts}.post_content
								 FROM {$wpdb->posts} WHERE post_type = 'wacm_default_attrs' and post_mime_type != 'moveok'");
	 
		$new_ = [];
		$position = 0;
		foreach($defaults_ as $value){
			
			$default_id 			= $value->ID;	
			$post_title 			= $value->post_title;
			$post_name 				= $value->post_name;
			$defaultes_attributes_ 	= unserialize( $value->post_content );
			
			foreach($defaultes_attributes_ as $attribute){
				
				$name = $attribute["slug"];
				$slug = sanitize_title($attribute["slug"]);
				 
				$new_[$slug]["name"]			= $name;
				$new_[$slug]["position"] 		= $position++;
				$new_[$slug]["is_visible"]		= (int) $attribute['visible'];
				$new_[$slug]["is_variation"]	= 0;
				$new_[$slug]["is_taxonomy"]		= (substr($name,0,3)=='pa_') ? 1 : 0;
				$new_[$slug]["value"]			= $attribute["values"] ?? [];
			}
 
			$my_post['post_title'] 		= wp_strip_all_tags( $post_title );
			$my_post['post_name'] 		= $post_name;
			$my_post['post_content']	= serialize($new_);
			$my_post['post_status'] 	= 'publish';
			$my_post['post_author'] 	= get_current_user_id();
			$my_post['post_type'] 		= WACM_POST_TYPE_DEFAULT;
	  
			wp_insert_post($my_post);
 
			$my_post2['post_mime_type']		= 'moveok';
			$my_post2['ID'] 				= $default_id;
			wp_update_post( $my_post2 );
			  
		}
	 
	}
	
}
return new WACM_Admin_Ajax();