<?php 

defined( 'ABSPATH' ) || exit;

class WACM_Admin_DF_Product extends Woocommerce_Attributes_Content{
	 
	function __construct() {
		 
		add_action( 'init', array( $this, 'init' ) );
		
		add_action( 'wp_ajax_wacm_add_attribute', array( $this, 'add_attribute' ) );
		// add_action( 'wp_ajax_nopriv_wacm_add_attribute', array( $this, 'add_attribute' ) );
		
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts_' ), 9 );		
		add_action( 'admin_footer', array( $this, 'admin_footer' ) );
    }
	
	function init() {
		global $pagenow;
		
		if ( (('post.php' === $pagenow ) && isset($_GET['post']) && 'product' == get_post_type( $_GET['post'] )) ||
				 (('post-new.php' === $pagenow ) && isset($_GET['post_type']) && 'product' ==  $_GET['post_type']) ){
				   
			// add_action( 'dokan_product_edit_after_inventory_variants', array( $this, 'attributes_content_toolbar'));
			add_action( 'woocommerce_product_options_attributes', array( $this, 'attributes_content_toolbar'));
		}
		
	}
 
	public function admin_enqueue_scripts_() {
	  
		wp_enqueue_script(
			'wacm-admin-df',
			plugins_url( '/assets/js/wacm-admin-df.js' , WACM_PLUGIN_FILE ),
			array( 'jquery', 'wc-backbone-modal' ,'underscore', 'backbone', 'wp-util'  ),
			WACM_VERSION,
			true
		);
		
		wp_localize_script( 'wacm-admin-df', 'wacm_admin',
			array(
				'ajaxurl' 				=> admin_url('admin-ajax.php') ,
				'plugins_url' 			=> plugins_url('', WACM_PLUGIN_FILE ),
				'add_attribute_nonce' 	=> wp_create_nonce( 'add-attribute' ),
				'_nonce' 				=> wp_create_nonce( 'wacm-admin-ajax' ),
			)
		);
		 
	}
	
	public function admin_footer(){
		
		$screen = get_current_screen();
		$screen_id = $screen ? $screen->id : '';
		  
		if( in_array( $screen_id , array( 'product' , WACM_POST_TYPE_DEFAULT , 'edit-' . WACM_POST_TYPE_DEFAULT ) )){
			
			include( WACM_ABSPATH . "/views/html-modal.php" );
		}
	}
	
	public function get_attributes_content($type=-1){
		
		global $wpdb;
		
		$new_param = array();
		
		$terms = get_terms( array( 'taxonomy' => 'wacm_group_default_attrs', 'hide_empty' => false, ) );
		$si = 1;
		
		foreach( $terms as $key => $value ){
			
			$name 		= $value->name;
			$term_id 	= $value->term_id;
			$slug 		= $value->slug;
				 
				$the_query = new WP_Query( array( 'post_type' => WACM_POST_TYPE_DEFAULT,
						'tax_query' => array(								 
					array(
						'taxonomy' => 'wacm_group_default_attrs',
						'field' => 'term_id',
						'terms' => $term_id
					 )						 
				) )); 
	
				$new_param[$slug][0]["title"] = $name;
				 
				if ( $the_query->have_posts() ) {
					
					while ( $the_query->have_posts() ) {
						$the_query->the_post();
						
						$new_param[$slug][0]["values"][] = array( "term_id"=> get_the_id() , "term_title"=> get_the_title() );
					}
								 
					wp_reset_postdata();
				} 
				 
			$si++;
							
		}


		$the_query = new WP_Query( array( 'post_type' => WACM_POST_TYPE_DEFAULT,
					'tax_query' => array(
			 array(
				'taxonomy' => 'wacm_group_default_attrs',
				'operator' => 'NOT EXISTS',
			),
		) )); 
		
		$new_param["un_group"][0]["title"] = "un Group";
		
		$the_query = $wpdb->get_results( "SELECT {$wpdb->posts}.ID,{$wpdb->posts}.post_title
											FROM {$wpdb->posts} WHERE post_type = '". WACM_POST_TYPE_DEFAULT . "'" );
		foreach($the_query as $value){
			
			$post_id	= $value->ID;	
			$post_title	= $value->post_title;	
			   
			$new_param["un_group"][0]["values"][] = array( "term_id"=> $post_id , "term_title"=> $post_title );
		}
		
		return $new_param;
	}
		
	public function attributes_content_toolbar(){
 
		$attributes_content_list = $this->get_attributes_content(); 
		
		include( WACM_ABSPATH . "/views/html-df-select-product.php" );
	}
	
	
	function add_attribute() {
		ob_start();
		
		check_ajax_referer( 'add-attribute', 'security' );

		if ( ! current_user_can( 'edit_products' ) || ! isset( $_POST['taxonomy'], $_POST['i'] ) ) {
			wp_die( -1 );
		}

		$i             	= absint( $_POST['i'] );
		$id_df			= absint( $_POST['df'] );
		$ai				= absint( $_POST['ai'] );
		$metabox_class 	= array();
		$attribute     	= new WC_Product_Attribute();

		$attribute->set_id( wc_attribute_taxonomy_id_by_name( sanitize_text_field( wp_unslash( $_POST['taxonomy'] ) ) ) );
		$attribute->set_name( sanitize_text_field( wp_unslash( $_POST['taxonomy'] ) ) );
		$attribute->set_visible( apply_filters( 'woocommerce_attribute_default_visibility', 1 ) );
		$attribute->set_variation( apply_filters( 'woocommerce_attribute_default_is_variation', 0 ) );

		if ( $attribute->is_taxonomy() ) {
			$metabox_class[] = 'taxonomy';
			$metabox_class[] = $attribute->get_name();
		}
		
		$result_df	= self::get_default_attributes_by_id( $id_df );
		$post_content = unserialize($result_df->post_content);
		$select_values = $post_content[sanitize_title($_POST['taxonomy'])]["value"];
		 
		include( WACM_ABSPATH . "/views/html-product-attribute.php" );
		wp_die();
	}

	function get_default_attributes_by_id( $id_post ) {
	 
		global $wpdb;
	 
		if( empty( $id_post ) )
			return;
		 
		$my_posts = get_post($id_post);	
		return $my_posts;
	}
	   
}

new WACM_Admin_DF_Product();
 