<?php

defined( 'ABSPATH' ) || exit;

class WACM_Admin extends Woocommerce_Attributes_Content{
		    
	function __construct() {
		 
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts_' ), 9 );
		 
        add_action( 'woocommerce_init',  array( $this, 'register_post_type' ) ,911 ,99 );
        add_action( 'admin_menu', array( $this, 'admin_menu' ) );

		add_action( 'admin_footer', array( $this, 'admin_footer' ) );
		
		add_action( 'admin_head', function (){
			
			if( $this->has_wacm_page() ){
				
				remove_all_actions( 'admin_notices' );
			}
		}, 1 );
		 
		add_action( 'admin_enqueue_scripts', function () {
		
			global $wp_styles,$wp_scripts;
			
			if( $this->has_wacm_page() ){			
					 
				foreach( $wp_styles->registered as $link ){
					
					$link_src 		= $link->src 	?? '';
					$link_handle 	= $link->handle ?? '';
					
					if(preg_match('#wp-content/plugins/(.*?)/#',$link_src,$mat_name)){
						
						if('woocommerce-attributes-content'!=$mat_name[1]){
							
							unset($wp_styles->registered[$link_handle]);
						}
					}
				}
				 
				foreach( $wp_scripts->registered as $link ){
					
					$link_src 		= $link->src 	?? '';
					$link_handle 	= $link->handle ?? '';
					
					if(preg_match('#wp-content/plugins/(.*?)/#',$link_src,$mat_name)){
						
						if('woocommerce-attributes-content'!=$mat_name[1]){
							
							unset($wp_scripts->registered[$link_handle]);
						}
					}
				}
			}			
		}, 110 );
		
    }
 
	
	public function admin_enqueue_scripts_() {
	 
		if( $this->has_wacm_page() ){			
			 
			wp_enqueue_style(
				'woodgka-admin-font',
				plugins_url( '/assets/css/font-awesome.min.css' , WACM_PLUGIN_FILE ),
				null,
				WACM_VERSION
			);
			 
			wp_enqueue_style(
				'wacm-admin',
				plugins_url( '/assets/css/wacm-admin.css' , WACM_PLUGIN_FILE ),
				null,
				WACM_VERSION
			);
			 
			wp_enqueue_script(
				'wacm-admin',
				plugins_url( '/assets/js/wacm-admin.js' , WACM_PLUGIN_FILE ),
				array(),
				WACM_VERSION,
				true
			);
			
			wp_enqueue_script(
				'wacm-admin-df',
				plugins_url( '/assets/js/wacm-admin-df.js' , WACM_PLUGIN_FILE ),
				array(),
				WACM_VERSION,
				true
			);
			
	 		wp_localize_script( 'wacm-admin', 'wacm_admin',
				array(
					'plugins_url' 	=> plugins_url('', WACM_PLUGIN_FILE ),
					'_nonce' 		=> wp_create_nonce( 'wacm-admin-ajax' ),
				)
			);
		 

		}  
	}
	
	public function admin_footer(){
		          
		 
	} 
	
	public function register_post_type() {
		 
		$labels = array(
			'name'                	=> __( 'Default Attribute', 'wacm' ),
			'singular_name'       	=> __( 'Default Attribute', 'wacm' ),
			'add_new'             	=> __( 'Add New Default Attribute', 'wacm' ),
			'add_new_item'        	=> __( 'Add New Default Attribute', 'wacm' ),
			'edit_item'           	=> __( 'Edit Default Attribute', 'wacm' ),
			'new_item'            	=> __( 'New Default Attribute', 'wacm' ),
			'all_items'          	=> __( 'All Default Attribute', 'wacm' ),
			'view_item'           	=> __( 'View Default Attribute', 'wacm' ),
			'search_items'        	=> __( 'Search Default Attribute', 'wacm' ),
			'not_found'           	=> __( 'No Default Attribute found', 'wacm' ),
			'not_found_in_trash'  	=> __( 'No Default Attribute found in Trash', 'wacm' ),
			'parent_item_colon'   	=> __( 'Parent Default Attribute:', 'wacm' ),
			'menu_name'           	=> __( 'Default Attribute', 'wacm' ),
		);

		$args = array(
			'public' => false,
			'labels' => $labels,
			'show_ui' => true,
			'supports' => array('title','name'),
			'taxonomies' => array('wacm_group_default_attrs'),
			'show_in_menu' => ''
	    );
	    register_post_type( WACM_POST_TYPE_DEFAULT , $args );
		
		
		register_taxonomy( 'wacm_group_default_attrs', WACM_POST_TYPE_DEFAULT,
			array(
				'labels' => array(
					'name'          => __( 'Group Default Attribute', 'wacm' ),
					'add_new_item'  => __( 'Add New Group', 'wacm' ),
					'new_item_name' => __( 'Add New Group', 'wacm' ),
				),
				'exclude_from_search' => true,
				'has_archive'         => true,
				'hierarchical'        => true,							 
			)
		);
    }
	
	public function admin_menu() {
		 
		if ( current_user_can( 'edit_products' ) ) {
				 
			// die('ali');
		 
			add_submenu_page(
				'edit.php?post_type=product',
				__( 'Attribute Manager', 'wacm' ),
				__( 'Attribute Manager', 'wacm' ),
				 'edit_products',
				'wacm',
				array( $this , 'attribute_manager_page_' )
			);

		}else{
			 
			$message    = sprintf( esc_html__( 'ACCCCESSSS' ) );

			echo wp_kses_post( sprintf( '<div class="error"><p><strong>%1$s</strong></p></div>', $message ) );			
		}
		
		 
	}
	  
	public function attribute_manager_page_() {
		
		global $wpdb;
		 
		$this->views('attribute-manager');
	}
	 
	function has_wacm_page(){
		
		return (isset($_GET['page']) && 'wacm'==$_GET['page']) ?? 0;
	} 
}
 
function WACM_Admin__update_all_count_taxonomy() {
	
	global $wpdb,$wp_taxonomies;
	
	$taxonomies = get_taxonomies();
	foreach( $taxonomies as $taxonomy ) {
		$args = array(
			'hide_empty' 	=> 0,
			'fields' 		=> 'ids'
		);
		$terms = get_terms( $taxonomy, $args );
		if( is_array( $terms ) && !empty( $terms ) ) wp_update_term_count_now( $terms, $taxonomy );
	}
}

function wacm_get_attribute_by_slug( $slug ){
	
	global $wpdb;
	
	$slug = str_replace('pa_','',$slug);
	
	$result = $wpdb->get_row( "
		SELECT *
		FROM {$wpdb->prefix}woocommerce_attribute_taxonomies
		WHERE attribute_name = '{$slug}'
	 ");
	 
	if ( !( is_wp_error( $result ) || is_null( $result ) ) )
		return $result;
	else
		return;
}
return new WACM_Admin();

