<?php
/**
 * Plugin Name: Woocommerce Invoice Pro
 * Plugin URI: https://zhaket.com/web/woocommerce-invoice-pro
 * Description: Using this plugin you can create an advanced and powerful invoice for woocommerce orders and send it to your customers.
 * Version: 11.8.3
 * Author: S.Reza Salehi
 * Author URI: http://sreza-salehi.ir
 * Requires Plugins: woocommerce
 * Text Domain: wip
 * Domain Path: /languages/
 */

if (!function_exists('get_plugin_data')) {
    require_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

if (!function_exists('dd')) {
    function dd($data)
    {
        echo '<div dir="ltr" style="text-align: left; background: #f5f5f4; padding: 10px; border: 1px solid #e7e5e4;">';
        highlight_string("<?php\n" . var_export($data, true) . "\n?>");
        echo '</div>';
    }
}

define('WIP_BASE_FILE', __FILE__);
$plugin_data = get_plugin_data(WIP_BASE_FILE);
define('WIP_BASENAME', plugin_basename(WIP_BASE_FILE));
define('WIP_NAME', $plugin_data['Name']);
define('WIP_VER', $plugin_data['Version']);
define('WIP_URI', $plugin_data['PluginURI']);
define('WIP_AUTHOR_URI', $plugin_data['AuthorURI']);
define('WIP_AUTHOR_NAME', $plugin_data['AuthorName']);

require(trailingslashit(plugin_dir_path(WIP_BASE_FILE)) . 'core.php');